#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"
TMP_PATH="/opt/oss/log/manager/easysuite_upgrade_config"

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 日志记录进/tmp/${SELF_FILE}.log
##################################################
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
}

# 备份容灾服务数据库数据
function backup_drservicedb_data()
{
    source /opt/oss/manager/bin/engr_profile.sh
    if [ ! -d "${OSS_ROOT}/apps/DRService" ]
    then
        return 0
    fi

    if [ -f "${SCRIPT_PATH}/pyscripts/query_database.pyc" ]
    then
        local query_database_file="${SCRIPT_PATH}/pyscripts/query_database.pyc"
    else
        if [ -f "${SCRIPT_PATH}/pyscripts/query_database.py" ]
        then
            local query_database_file="${SCRIPT_PATH}/pyscripts/query_database.py"
        else
            LOG "ERROR" "[backup_drservicedb_data] Error: Can not find query_database file."
            return 1
        fi
    fi

    local arb_config="${TARGET_FILE}"
    if [ -f "${arb_config}" ]
    then
        rm -f "${arb_config}"
    fi
    local result=$(python ${query_database_file} 'get_db_info' 'managedbsvr' 'drservicedb' ${arb_config})
    echo "${result}" | grep "EXEC_SUCCESS" &>/dev/null
    if [ $? -ne 0 -o ! -f "${arb_config}" ]
    then
        LOG "ERROR" "[backup_drservicedb_data] Error: ${result}"
        LOG "ERROR" "[backup_drservicedb_data] Error: Failed to backup drservicedb data."
        return 1
    fi
    return 0
}

function init_path() {
    SRC=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['src_version'])" 2>/dev/null)
    if [ -z "${SRC}" ]
    then
        LOG "ERROR" "SRC is null."
        return 1
    fi
    DES=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['des_version'])" 2>/dev/null)
    if [ -z "${DES}" ]
    then
        LOG "ERROR" "DES is null."
        return 1
    fi
    TARGET_PATH="/opt/upgrade/backup/${SRC}-${DES}"
    TARGET_FILE="${TARGET_PATH}/query_arb.conf"
    mkdir -p ${TARGET_PATH} 2>/dev/null
    if [ $? -ne 0 ]
    then
        LOG "ERROR" "mkdir ${TARGET_PATH} failed."
        return 1
    fi
}

function main()
{
    check_user || return 1
    # 创建日志目录
    [ ! -d "${LOG_PATH}" ] && mkdir -p ${LOG_PATH}
    # 创建临时文件目录
    [ ! -d "${TMP_PATH}" ] && mkdir -p ${TMP_PATH}
    INPUTPATH="$2"
    init_path || return 1

    lock_file="${TMP_PATH}/pre_upgrade_backup_drservicedb_lock"
    [ -f ${lock_file} ] && return 0
    [ ! -f ${lock_file} ] && touch ${lock_file}
    backup_drservicedb_data || return 1
    rm -rf ${lock_file}

}

main $@
exit $?
