# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2020-01-04 创建
"""
import sys
import time
import json
from util import httpclient
from commonlog import Logger

LOG = Logger().getinstance("query_feature")


def get_productid(in_productname):
    """
    功能描述：根据产品名获取产品id
    参数：产品名
    返回值：产品id
    异常描述：无
    修改记录：新增方法
    """
    productid = ""
    status = 200
    query_productid_url = "/rest/plat/omp/v1/main/resmgr/products"
    for time_count in range(12):
        status, response = httpclient.IRHttpClient().get(query_productid_url)
        if status == 200:
            break
        else:
            LOG.error("Failed to get nodeinfo from " \
                      "%s.Response:%s" % (query_productid_url, response))
            time.sleep(10)
            continue
    if time_count == 11 and status != 200:
        return productid

    try:
        product_data = json.loads(response)
        # 获取所有产品信息
        for tmp_product in product_data:
            if in_productname == tmp_product.get("productName"):
                productid = tmp_product.get("productID")
                break
    except IndexError as e_msg:
        LOG.error("Exception:" % e_msg)
        return productid
    except json.decoder.JSONDecodeError as e_msg:
        LOG.error("Exception:" % e_msg)
        return productid
    return productid


def get_profeature(in_productname):
    """
    功能描述：调用平台接口查询产品当前特性集
    参数：产品名
    返回值：当前产品特性集
    异常描述：无
    修改记录：新增方法
    """
    featurelist = []
    res_productid = get_productid(in_productname)
    if res_productid is None or res_productid == "":
        return ",".join(featurelist)

    query_feature_url = "/rest/plat/sysmgr/v1/main/swmgr/product/deployment?product-id=%s" \
                        % res_productid
    for time_count in range(12):
        status, response = httpclient.IRHttpClient().get(query_feature_url)
        if status == 200:
            break
        else:
            LOG.error("Failed to get featureinfo from " \
                      "%s.Response:%s" % (query_feature_url, response))
            time.sleep(10)
            continue
    if time_count == 11 and status != 200:
        return ",".join(featurelist)

    try:
        product_data = json.loads(response)
        for tmp_product in product_data.get("entity"):
            if tmp_product.get("productName") == in_productname:
                featurelist = tmp_product.get("features")
                break
    except IndexError as e_msg:
        LOG.error("Exception:" % e_msg)
        return ",".join(featurelist)
    except json.decoder.JSONDecodeError as e_msg:
        LOG.error("Exception:" % e_msg)
        return ",".join(featurelist)
    return ",".join(featurelist)


def main():
    """
    功能描述：主入口
    参数：无
    返回值：无
    异常描述：无
    修改记录：新增方法
    """
    argnum = len(sys.argv)
    if argnum != 2:
        LOG.error("Error:The parameter is error.")
        print("")
        sys.exit(1)
    product_name = sys.argv[1]
    if product_name == "":
        LOG.error("Error:The parameter is error.")
        print("")
        sys.exit(1)
    LOG.info("The parameter is %s." % product_name)
    feature_str = get_profeature(product_name)
    if feature_str is None or feature_str == "":
        LOG.error("Error:Failed to query featurelist.")
        sys.exit(1)
    print(feature_str)


if __name__ == '__main__':
    main()