# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import inspect
import json
import sys
import time
from datetime import datetime

from util import httpclient

from commonlog import Logger
from taskmgr_util import Taskmgrutil

logger = Logger().getinstance(sys.argv[0])
# 请求正常返回码范围
NORMAL_STATUS = [200, 207]


def is_request_success(status):
    """
    功能说明:请求是否成功
    :param status: 状态码
    :return:
    """
    if NORMAL_STATUS[0] <= status <= NORMAL_STATUS[1]:
        return True
    return False


class Unieptaskmgr:
    @staticmethod
    def get_function_name():
        """获取正在运行函数(或方法)名称"""
        return inspect.stack()[1][3]

    @staticmethod
    def send_post_request(task_url, params):
        status = 400
        response = f'{Unieptaskmgr.get_function_name()} error'
        for _ in range(1, 3):
            status, response = httpclient.IRHttpClient().post(task_url, params)
            if is_request_success(status):
                break
            logger.info("[function_name:%s] url:%s status:%s response:%s" % (
                Unieptaskmgr.get_function_name(), task_url, status, response))
            # rest接口查询失败重试10次
            time.sleep(1)
        if not is_request_success(status):
            return False, ""
        return True, response

    @staticmethod
    def send_put_request(task_url):
        for _ in range(1, 3):
            status, response = httpclient.IRHttpClient().put(task_url)
            if is_request_success(status):
                break
            logger.info("[function_name:%s] url:%s status:%s response:%s" % (
                Unieptaskmgr.get_function_name(), task_url, status, response))
            # rest接口查询失败重试10次
            time.sleep(1)
        if not is_request_success(status):
            return False, ""
        return True, response

    @staticmethod
    def send_get_request(task_url):
        for _ in range(1, 3):
            status, response = httpclient.IRHttpClient().get(task_url)
            if is_request_success(status):
                break
            logger.info("[function_name:%s] url:%s status:%s response:%s" % (
                Unieptaskmgr.get_function_name(), task_url, status, response))
            # rest接口查询失败重试10次
            time.sleep(1)
        if not is_request_success(status):
            return False, ""
        return True, response

    def query_task_status(self, task_url):
        """
        功能描述：查询管理面任务运行状态
        参数：无
        返回： progress,status,msg
        修改记录：新增方法
        """
        task_dct = dict()
        flag = True
        for _ in range(3):
            retstatus, response = self.send_get_request(task_url)
            if retstatus is False:
                return {"progress": "", "status": "", "msg": ""}
            try:
                task_dct = json.loads(response)[0]
                flag = False
                break
            except Exception:
                logger.info("[function_name:%s] url:%s status:%s response:%s" % (
                    self.get_function_name(), task_url, retstatus, response))
                time.sleep(1)
        if flag:
            return {"progress": "", "status": "", "msg": ""}
        task_progress = task_dct.get("progress")
        task_status = task_dct.get("currentState")
        task_msg = task_dct.get("details")
        return {"progress": task_progress, "status": task_status, "msg": task_msg}

    @staticmethod
    def add_time(old_msg, new_msg):

        if old_msg.find("\r\n") >= 0:
            old_msg = old_msg.replace("\n\r", "\n")
            olds = old_msg.split('\n')
        elif new_msg.find("\n") >= 0:
            olds = old_msg.split('\n')
        elif len(old_msg) > 0:
            olds = [old_msg]
        else:
            olds = []

        if new_msg.find("\r\n") >= 0:
            new_msg = new_msg.replace("\n\r", "\n")
            news = new_msg.split('\n')
        elif new_msg.find("\n") >= 0:
            news = new_msg.split('\n')
        elif len(new_msg) > 0:
            news = [new_msg]
        else:
            news = []
        print("lenolds:" + str(len(olds)))
        print("newlen:" + str(len(news)) + str(news))
        if len(news) >= len(olds):
            for i in range(len(olds), len(news) - 1):
                olds.append(
                    "[%s]" % time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()) + " " + news[i])

            old_msg = '\n'.join(olds)
        else:
            old_msg = '\n'.join(olds)
        return old_msg

    def wait_uniep_task(self, response, e_task_path):
        """
        功能描述：等待任务完成
        参数：productname, pkgname, operation
        返回： response
        修改记录：新增方法
        """
        taskmgr_function = Taskmgrutil()
        res_data = json.loads(response)
        error_code = res_data.get("errorCode")
        result = res_data.get("result")
        if error_code != "" or result != "OK":
            logger.error("Failed to create task:%s" % response)
            return False
        request_url = res_data.get("url")
        if not request_url:
            now_time = datetime.strptime(datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                                         '%Y-%m-%d %H:%M:%S')
            Taskmgrutil.set_msg_append(e_task_path,
                                       "[%s]" % now_time + " " + "Response:%s" % res_data)
            return False
        finish_status = ["SUCCESS", "PARTIAL_SUCCESS", "FAILURE", "TERMINATED"]
        start_time = datetime.strptime(datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                                       '%Y-%m-%d %H:%M:%S')
        old_msg = "[%s]" % start_time + " " + Taskmgrutil.get_res_dict().get("start_db_up")

        while True:
            task_data = self.query_task_status(request_url)
            if task_data.get("status") in finish_status:
                old_msg = self.add_time(old_msg, task_data.get("msg"))
                taskmgr_function.set_e_taskmsg(e_task_path, old_msg)
                if task_data.get("status") != "SUCCESS":
                    return False
                break
            else:
                Taskmgrutil.set_e_taskstatus(e_task_path, task_data.get("status"))
                Taskmgrutil.set_e_taskprogress(e_task_path, task_data.get("progress"))
                old_msg = self.add_time(old_msg, task_data.get("msg"))
                taskmgr_function.set_e_taskmsg(e_task_path, old_msg)
                time.sleep(3)
                continue
        return True
