#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    local user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 获取恢复数据库软件的OMP节点
##################################################
function get_omp_node_ip()
{
    grep "^managerip" ${OSS_ROOT}/var/agent/managerip.conf | grep -q ','
    if [ $? -ne 0 ]
    then
        # OMP单节点情况下直接返回
        local managerip=$(grep "^managerip" ${OSS_ROOT}/var/agent/managerip.conf | awk -F"=|," '{print $2}' 2>/dev/null)
        [ -z "${managerip}" ] && return 1
        echo "master,${managerip}"
        return 0
    else
        # OMP多节点情况
        # 获取备份时OMP主备数据库实例运行状态
        local master_node_id="0"
        local check_reg="mgrdbInstanceName=managedbsvr"
        get_manage_node_name
        first_manager_node=$(echo ${manage_node_name//,/ } | awk '{print $1}')
        local management="/opt/upgrade/${first_manager_node}/management.tar.gz"
        [ ! -f "${management}" ] && return 1
        # 只有主节点备份数据能找到标志字段
        zgrep --binary-files=text "${check_reg}" ${management} | grep "${check_reg}" &>/dev/null
        if [ $? -ne 0 ]
        then
            local master_node_id="1"
        fi
        
        # 获取参数工具
        local access_file="${OSS_ROOT}/etc/sysconf/nodelists.json"
        local restore_db_tool="${SCRIPT_PATH}/pyscripts/restore_db_tool.py"
        if [ ! -f ${restore_db_tool} ]
        then
            local restore_db_tool="${SCRIPT_PATH}/pyscripts/restore_db_tool.pyc"
            [ ! -f "${restore_db_tool}" ] && return 1
        fi
        
        # 获取OMP主备站点节点间通讯IP
        local management_node_info=$(python ${restore_db_tool} get_ha_access_ip ${access_file})
        local node_0_info=$(echo "${management_node_info}" | awk -F";" '{print $1}' 2>/dev/null)
        local node_1_info=$(echo "${management_node_info}" | awk -F";" '{print $2}' 2>/dev/null)
        [ -z "${node_0_info}" -o -z "${node_1_info}" ] && return 1
        
        local master_info=""
        local standby_info=""
        if [ "${master_node_id}" == "0" ]
        then
            local master_info=$(echo "${node_0_info}" | sed "s/0,/master;0,/g")
            local standby_info=$(echo "${node_1_info}" | sed "s/1,/standby;1,/g")
        else
            local master_info=$(echo "${node_1_info}" | sed "s/1,/master;1,/g")
            local standby_info=$(echo "${node_0_info}" | sed "s/0,/standby;0,/g")
        fi
        echo "${master_info};${standby_info}"
        return 0
    fi
}

##################################################
# 下载最近管理面备份包到/opt/upgrade
##################################################
function download_backup_pkg()
{
    # 下载备份包工具
    local sftp_download="${SCRIPT_PATH}/sftp_download.sh"
    local restore_db_tool="${SCRIPT_PATH}/pyscripts/restore_db_tool.py"
    if [ ! -f ${restore_db_tool} ]
    then
        local restore_db_tool="${SCRIPT_PATH}/pyscripts/restore_db_tool.pyc"
        [ ! -f "${restore_db_tool}" ] && return 1
    fi

    local result=$(python ${restore_db_tool} download_backup_pkg ${sftp_download})
    echo "${result}" | grep "DOWNLOAD_SUCCESS" &>/dev/null

    return $?
}

##################################################
# 获取管理节点节点名
##################################################
function get_manage_node()
{
    # 下载备份包工具
    local restore_db_tool="${SCRIPT_PATH}/pyscripts/restore_db_tool.py"
    if [ ! -f ${restore_db_tool} ]
    then
        local restore_db_tool="${SCRIPT_PATH}/pyscripts/restore_db_tool.pyc"
        [ ! -f "${restore_db_tool}" ] && return 1
    fi
    python ${restore_db_tool} get_manage_node
}

##################################################
# 获取管理节点名
##################################################
function get_manage_node_name()
{
    manage_node_name=$(get_manage_node)
}

##################################################
# 程序入口
##################################################
function main()
{
    check_user || return 1

    source /opt/oss/manager/bin/engr_profile.sh
    
    local action=$1
    case ${action} in
    "get_omp_node_ip")
        get_omp_node_ip
        return $?
    ;;
    "download_backup_pkg")
        download_backup_pkg
        return $?
    ;;
    "get_manage_node")
        get_manage_node
        return $?
    ;;
    esac
}

main $@
exit $?
