#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 校验执行用户
# 脚本要求使用root用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    # 外部输入参数数量
    input_params_num=4
    if [ $# -ne ${input_params_num} ]
    then
        return 1
    fi

    # 任务唯一ID
    TASKID="${1}"
    # 产品名称
    PRODUCT_NAME="${2}"
    # 源版本
    SRC_VERSION="${3}"
    # 目标版本
    DES_VERSION="${4}"
}

# 处理任务打印
function record_es_log()
{
    LOG_PRINT "${1}" "${2}" >>"${TASK_LOG_FILE}"
}

# 下发kmc切换命令
function switch_cloudsop_cmd()
{
    local failed_flag="${1}"
    if [ -f "${failed_flag}" ]
    then
        osskey -cmd SwitchCloudSOP -force -retry >>"${TASK_LOG_FILE}"
    else
        osskey -cmd SwitchCloudSOP -force >>"${TASK_LOG_FILE}"
    fi
}

function switch_cloudsop()
{
    # 命令单次任务执行结果文件
    local failed_flag="${LOG_PATH}/${TASKID}.fail.flag"
    # 标志文件判断
    flag_file="${SCRIPT_PATH}/${SELF_FILE//.sh/}${RANDOM}"
    # ossadm: 创建工作路径
    config_path="${WORK_PATH}/${SRC_VERSION}-${DES_VERSION}/workpath-${PRODUCT_NAME}/pre_upgrade"
    # 生成文件配置
    config_file="${config_path}/pre_upgrade_config.properties"
    grep -q "kmc_mode_manager=true" "${config_file}"
    if [ $? -eq 0 ]
    then
        record_es_log "INFO" "Mode switching is not required.Skip current step."
        return 0
    fi
    record_es_log "INFO" "Start to switch to cloudsop mode"
    . ${CLOUDSOP_PROFILE}
    # 标志文件判断法
    rm -f "${flag_file}" &>/dev/null
    # 核心任务挂起
    (switch_cloudsop_cmd "${failed_flag}";echo "$?" >"${flag_file}" )&

    # 刷新进度,并给出进程失败返回码
    fresh_task_progress "${TASKID}" "10" "${flag_file}" "0" "100"
    result=$?
    if [ ${result} -ne 0 ]
    then
        [ ! -f "${failed_flag}" ] && echo retcode=${result} > "${failed_flag}"
        record_es_log "INFO" "Failed to switch to cloudsop mode"
        return 1
    fi
    [ -f "${failed_flag}" ] && rm -f "${failed_flag}"
    record_es_log "INFO" "Finished to switch to cloudsop mode"
    return 0
}

function main()
{
    # 加载公共方法
    . ${SCRIPT_PATH}/common.sh
    LOG "INFO" "Start to init ${LOG_FILE}."
    init_params "$@" || return 1
    # 初始化升级任务
    init_taskmgr "${TASKID}"
    TASK_LOG_FILE="${TASK_MGR_PATH}/${TASKID}/task.log"
    fresh_es_progress "${TASKID}" "1"
    switch_cloudsop
    if [ $? -ne 0 ]
    then
        do_exit "${TASKID}"
        return 1
    fi
    fresh_es_status "${TASKID}" "success"
    fresh_es_progress "${TASKID}" "100"
}

main "$@" &
exit 0