#!/bin/bash
# 脚本名
SELF_FILE=$(basename $0)

# suspend,no-suspend
run_type="${1}"
script_name="${2}"
script_id="${3}"
script_path="${4}"
all_scripts=""
task_mgr_path="/opt/upgrade/easysuite_upgrade/taskmgr/${script_id}"
es_custom_task="/opt/upgrade/easysuite_upgrade/logs/es_custom_task.log"

function check_task()
{
    echo "${script_name}" | grep -q ','
    if [[ $? -eq 0 ]]
    then
        for one_script in ${script_name//,/ }
        do
            if [[ -z "${all_scripts}" ]]
            then
                all_scripts="${one_script}"
            else
                all_scripts="${all_scripts}|${one_script}"
            fi
        done
    fi
    if [[ -n "${all_scripts}" ]]
    then
        ps -ef | grep -E ${all_scripts} | grep -v "${SELF_FILE}" |grep -v "bash -c" | grep ${script_id}
        result=$?
    else
        ps -ef | fgrep ${script_name} | grep -v "${SELF_FILE}" |grep -v "bash -c" | grep ${script_id}
        result=$?
    fi
    
    if [[ ${result} -ne 0 ]]
    then
        if [[ ! -d ${task_mgr_path} ]]
        then
            return 0
        fi
        # 文件存在并且task.status 为finish;success;不再重复下发命令
        task_status="${task_mgr_path}/task.status"
        [ "${retry_success}" == "false" -a -f "${task_status}" ] && grep -iqE "status=finish|status=success" "${task_status}"
        if [ $? -eq 0 ]
        then
            logger -p local0.info "custom_cmd.check_task:the task run ${script_name} already finished."
            echo upgrade_custom_su_cmd_success{0}
            return 1
        fi
        find ${task_mgr_path} -name "task.*" | grep -v task.log | xargs rm -f
    else
        logger -p local0.info "custom_cmd.check_task:the task run ${script_name} already existed."
        echo upgrade_custom_su_cmd_success{0}
        return 1
    fi
}

function check_param()
{
    all_param=""
    param_num=0
    for args in "$@"
    do
        let param_num++
        if [[ "${args}" =~ "&" || "${args}" =~ ";" || "${args}" =~ "$" || "${args}" =~ "|" ]]
        then
            logger -p local0.info "custom_cmd.check_param:the task param is invalid."
            echo upgrade_custom_su_cmd_success{1}
            return 1
        fi
        if [[ ${param_num} -gt 4 ]]
        then
            if [[ -z "${all_param}" ]]
            then
                all_param="${args}"
            else
                all_param="${all_param} ${args}"
            fi
        fi
    done
}

function run_script()
{
    # suspend
    # no-suspend
    if [[ "${run_type}" == "suspend" ]]
    then
        nohup bash ${script_path} ${all_param} &>>${es_custom_task} &
    else
        bash ${script_path} ${all_param} 2>>${es_custom_task}
    fi
}

function initial_log()
{
    mkdir -p $(dirname ${es_custom_task})
}

function check_task_result()
{
    count=1
    while true
    do
        let count++
        if [[ -n "${all_scripts}" ]]
        then
            ps -ef | grep -E ${all_scripts} | grep -v "${SELF_FILE}" |grep -v "bash -c" | grep ${script_id} &>>${es_custom_task}
            result=$?
        else
            ps -ef | fgrep ${script_name} | grep -v "${SELF_FILE}" |grep -v "bash -c" | grep ${script_id} &>>${es_custom_task}
            result=$?
        fi
        cat "${task_mgr_path}/task.status" 2>/dev/null | egrep "finish|fail|error|success" &>>${es_custom_task}
        result2=$?
        if [[ ${result} -eq 0 || ${result2} -eq 0 ]]
        then
            result=0
            logger -p local0.info "check_task:success to start ${script_name}"
            echo upgrade_custom_su_cmd_success{${result}}
            break
        elif [[ ${count} -eq 60 ]]
        then
            result=1
            logger -p local0.err "check_task:fail to start ${script_name}"
            echo upgrade_custom_su_cmd_success{${result}}
            break
        fi
        sleep 1
    done
}

function main()
{
    check_param "$@" || return 1
    check_task || return 0
    initial_log
    run_script || return 1
    check_task_result
}

main "$@"
exit 0
