#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"


##################################################
# 校验执行用户
# 脚本要求使用root用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

function main()
{
    # 加载公共方法
    . ${SCRIPT_PATH}/common.sh
    LOG "INFO" "Start to init ${LOG_FILE}."
    # 加载平台证书环境变量
    export SSL_ROOT=/opt/oss/manager/etc/ssl
    export CIPHER_ROOT=/opt/oss/manager/etc/cipher
    . /opt/oss/manager/bin/engr_profile.sh >>${LOG_FILE} 2>&1
    which python >>${LOG_FILE} 2>&1
    if [ ! -f "${py_script}" ]
    then
        py_script="${py_script}c"
    fi
    input=$@
    LOG "INFO" "Input:${input[@]}"
    python ${py_script} "$@" >>${LOG_FILE} 2>&1 &
}

main "$@"
exit 0