#!/bin/bash

check_etc_hosts()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking the /etc/hosts."

    #检查/etc/hosts中是否配置127.0.0.1 localhost
    checkResult=$(cat /etc/hosts | grep -vw '^#' | awk '{if ($1 == "127.0.0.1" && $2 == "localhost"){print $0}}')
    [[ -z "${checkResult}" ]] && fn_sys_log_error "${host_ip}: '127.0.0.1 localhost' is not configured in '/etc/hosts'."

    #检查当前节点的影射关系在/etc/hosts中是否匹配
    checkResult=$(cat /etc/hosts | grep -vw '^#' | awk '{if ($1 == "'${host_ip}'"){print $0}}')
    hostname_str=$(hostname)
    if [[ -z "${checkResult}" ]];then
        checkhostip=$(cat /etc/hosts | grep -vw '^#' | grep "${host_ip}\|${hostname_str}")
        [[ -z "${checkhostip}" ]] && fn_sys_log_error "The IP address and hostname in the '/etc/hosts' do not match: ${host_ip} ${hostname_str}."
    fi

    #检查hostname是否已经配置
    hostname -i &> /dev/null
    [[ $? -ne 0 ]] && fn_sys_log_error "${host_ip}: the hostname is not configured in '/etc/hosts'. "

    # 检查hostname对应的ip值是否唯一
    hostname_ip=$(hostname -i)
    [[ "$(fn_sys_is_valid_ip ${hostname_ip})" == "false" ]] && fn_sys_log_error "The command output of the 'hostname -i' is not an IP address." && return 1
    ip_count=$(echo ${hostname_ip} | wc -w)
    [[ "${ip_count}" -ne 1 ]] && fn_sys_log_error "${host_ip}: the hostname corresponds to more than one ip in '/etc/hosts'."

    #检查hostname -i对应的ip值是否存在于ifconfig列表中
    ifconfig | grep -w "${hostname_ip}"  &> /dev/null
    [[ $? -ne 0 ]] && fn_sys_log_error "${host_ip}: the ip ${hostname_ip} in /etc/hosts is not in ifconfig/ip list."

    # 检查/etc/hosts中是否存在一个IP对应多个主机的情况
    hostname_count=$(cat /etc/hosts | grep -vw '^#' | awk '{if ($1 == "'${hostname_ip}'"){print $0}}' | wc -l)
    [[ "${hostname_count}" -ne 1 ]] && fn_sys_log_error "${host_ip}: the ip ${hostname_ip} corresponds to more than one hostname in '/etc/hosts'."
    fn_sys_log_info "${host_ip}: Success checking the /etc/hosts."
}
