#!/bin/bash
#------------------------------------------------------------------------------
#检查内核参数zone_reclaim_mode
#------------------------------------------------------------------------------

check_zone_reclaim()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking the zone_reclaim_mode."
    if [ -e "/proc/sys/vm/zone_reclaim_mode" ]
    then
        checkResult=$(cat /proc/sys/vm/zone_reclaim_mode)
        if [ "${checkResult}" -eq 0 ]
        then
            fn_sys_log_info "${host_ip}: zone_reclaim_mode is 0."
        else
            fn_sys_log_error "${host_ip}: The 'zone_reclaim_mode' is configured incorrectly."
        fi
    fi
    fn_sys_log_info "${host_ip}: Success checking the zone_reclaim_mode."
        
}
