#!/usr/bin/env bash

fn_modify_crontab()
{
    fn_sys_log_info "${host_ip}: Start to modify cron.allow."

    sed -i '/^ossuser/d' /etc/cron.allow
    echo 'ossuser' >> /etc/cron.allow

    fn_sys_log_info "${host_ip}: Success to modify cron.allow."
}

fn_create_backup_dir()
{
    fn_sys_log_info "${host_ip}: Start making dir for backup."
    if [[ ! -d /opt/backup ]]
    then
        mkdir -m 750 -p /opt/backup
    fi

    if [[ ! -d /opt/backup/ncendp ]]
    then
        mkdir -m 750 -p /opt/backup/ncendp
    fi
    chown 3004:2000 /opt/backup/ncendp
    chmod 750 /opt/backup/ncendp
    fn_sys_log_info "${host_ip}: Success making dir for backup."
}


set_unix2()
{
	cat /etc/pam.d/common-session | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo session required        pam_unix2.so>>/etc/pam.d/common-session
	fi

	cat /etc/pam.d/common-password | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo password    sufficient  pam_unix2.so  use_authtok nullok>>/etc/pam.d/common-password
	fi

	cat /etc/pam.d/common-auth | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo auth    sufficient      pam_unix2.so>>/etc/pam.d/common-auth
	fi

	cat /etc/pam.d/common-account | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo account required        pam_unix2.so>>/etc/pam.d/common-account
	fi

	cat /etc/pam.d/common-session | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo session required        pam_unix.so>>/etc/pam.d/common-session
	fi

	cat /etc/pam.d/common-password | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo password    sufficient  pam_unix.so>>/etc/pam.d/common-password
	fi

	cat /etc/pam.d/common-auth | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo auth    sufficient      pam_unix.so>>/etc/pam.d/common-auth
	fi

	cat /etc/pam.d/common-account | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo account required        pam_unix.so>>/etc/pam.d/common-account
	fi
}

check_cron_mode()
{
    # This function is used to change cron mode to process
    cron_mode=`cat /usr/lib/systemd/system/cron.service | grep -i KillMode`
    if [ "${cron_mode}" = "" ];then
        # condition 1: parameter killMode process is not exist
        fn_sys_log_info "${host_ip}: Current cron kill mode is: ${cron_mode}, start to change kill mode to process"
        line_number=`grep -n "Restart" /usr/lib/systemd/system/cron.service | awk -F: '{print $1}' | head -1`
        sed -i "$line_number s/^/KillMode=process\n/" /usr/lib/systemd/system/cron.service
        systemctl daemon-reload
        if [ $? -ne 0 ]; then
            fn_sys_log_error "${host_ip}: Change crom mode failed, please check cron service config. cmd: systemctl daemon-reload, ret: $?"
            return 1
        fi
    else
        # condition 2: parameter killMode is not process, need to change to process
        kill_mode=`cat /usr/lib/systemd/system/cron.service | grep -i KillMode=process`
        if [ "${kill_mode}" = "" ];then
            fn_sys_log_info "${host_ip}: Cron kill mode is not set, start to set kill mode to process"
            sed -i "s#KillMode=.*#KillMode=process#g" /usr/lib/systemd/system/cron.service
            systemctl daemon-reload
            if [ $? -ne 0 ]; then
                fn_sys_log_error "${host_ip}: Change crom mode failed, please check cron service config. cmd: systemctl daemon-reload, ret: $?"
                return 1
            fi
        fi
    fi
    # finally check wheher change success before exit
    kill_mode=`cat /usr/lib/systemd/system/cron.service | grep -i KillMode=process`
    if [ "${kill_mode}" = "" ]; then
        fn_sys_log_error "${host_ip}: Change crom kill mode to process failed."
        return 1
    fi
    fn_sys_log_info "${host_ip}: Check cron mode success."
}

config_specific_file()
{
    source_file=$1
    key_word=$2
    target_cmd=$3

    crack_mode=`cat ${source_file} | grep -i ${key_word} | grep -v '#' `
    if [ $? -eq 0 ]; then
        # if enhance pwd check mode, current pwd may not fit, this is not required in fi install
        log WARNING "Current mod is: ${crack_mode} , not need to change ${key_word} config" ${LOG_FILE}
    else
        # condition 2, add config if system not config this
        log WARNING "${key_word} not config in given path, start to add ${key_word}" ${LOG_FILE}
        echo "${target_cmd}" >> ${source_file}
    fi
}

config_common_pwd()
{
    # This function used to config pwd auth method of FI
    pwcheck_mod=`cat /etc/pam.d/common-password | grep -i pam_pwcheck.so`
    if [ "${pwcheck_mod}" != "" ]; then
        # if enhance pwd check mode, current pwd may not fit, this is not required in fi install
        log WARNING "pvalue check mode might cause error, mode is: ${pwcheck_mod}" ${LOG_FILE}
    fi

    crack_mod_cmd="password    required   pam_cracklib.so retry=3 minlen=8 difok=2 dcredit=-1 ucredit=-1 lcredit=-1 ocredit=-1 enforce_for_root"
    config_specific_file /etc/pam.d/common-password pam_cracklib.so "${crack_mod_cmd}"

    pam_pwhistory_cmd="password  required  pam_pwhistory.so  remember=12 use_authtok use_first_pass enforce_for_root crypt=sha256"
    config_specific_file /etc/pam.d/common-password pam_pwhistory.so "${pam_pwhistory_cmd}"

    pam_unix2_cmd="password   required   pam_unix2.so   nullok use_authtok"
    config_specific_file /etc/pam.d/common-password pam_unix2.so "${pam_unix2_cmd}"

    pam_unix_cmd="password    required     pam_unix.so    nullok use_authtok"
    config_specific_file /etc/pam.d/common-password pam_unix.so "${pam_unix_cmd}"

    pam_ldap_cmd="password    required     pam_ldap.so try_first_pass use_authtok"
    config_specific_file /etc/pam.d/common-password pam_ldap.so "${pam_ldap_cmd}"

    log INFO "config pam common pvalue auth success" ${LOG_FILE}
}

establish_link(){
    # 当前要在suse12.4下进行该步骤
    version=`cat /etc/os-release | grep ^VERSION_ID | sed 's/VERSION_ID="\(.*\)"/\1/g'`
    if [[ ${version} == "12.4" ]];then
        log WARNING "establish link /sbin/ethtool to /usr/sbin/ethtool" ${LOG_FILE}
        if [[ ! -L /sbin/ethtool ]];then
            ln -s /usr/sbin/ethtool  /sbin/ethtool
        fi
    fi
}

config_suse(){
    cat /proc/version  | grep "suse"
    [[ $? -ne 0 ]] && return 1
    set_unix2
    # add this func to avoid fi c70 version error
    check_cron_mode
    # config common password
    config_common_pwd
    establish_link
}

config_os()
{
    host_ip=$1
    fn_create_backup_dir
    fn_modify_crontab
    config_suse
}