#!/usr/bin/env bash

###############################################################################################
function fn_init()
{
    readonly l_script_path=$(cd $(dirname $0); pwd)
    readonly c_app_root="$l_script_path"
    source ${c_app_root}/utils/load_all_util.sh
    fn_sys_set_logging_verbose "$SYS_LOGGING_DEBUG"

    readonly oss_profile="/opt/oss/manager/agent/bin/engr_profile.sh"
    source ${oss_profile}

    readonly c_log_file="${l_script_path}/oss.param_change.log"
    readonly c_fi_custom_file="/tmp/ficluster_conf_after_install.json"
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"
    export _APP_LOG_DIR=${l_script_path}
    export PYTHONPATH=${l_script_path}/../pyscript:${PYTHONPATH}
    return 0
}

###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before change param."
    fn_sys_assert_current_user_matched "ossadm" || return 1
    fn_sys_assert_is_file "c_fi_custom_file" || return 1
    return 0
}


###################################################
#
# 调用python脚本生成集群信息。
#
###################################################
function fn_generate_cluster_info()
{
    fn_sys_log_info "Start generating node information."
    ${PYTHONHOME}/bin/python "${l_script_path}/../pyscript/actions/param_modify_launch.pyc" "${c_log_file}" "${c_fi_custom_file}"
    [ "$?" -ne "0" ] && fn_sys_log_error "Invoking [$c_tool_script] ... Failed" && return 1
    return 0
}


###############################################################################################
function fn_do()
{
    fn_sys_log_info "Start to process the parameter modification."

    fn_precheck || return 1

    fn_generate_cluster_info || return 1
    # 此echo不可删除，NCE工程对此有判断依赖
    echo "End to process the parameter modification."
    fn_sys_log_info "End to process the parameter modification."

    return 0
}

###############################################################################################
function fn_main()
{
    readonly c_start_time="$(date +%s)"
    fn_init

    fn_sys_log_enter

    fn_do
    local l_result="$?"

    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_leave "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"  >> "$c_log_file" 2>&1

    return "$l_result"
}

###############################################################################################
fn_main
result="$?"
fn_sys_audit_log "$result" "Modifying component parameters" "The process ends."
exit "$result"
