#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    iptable_dnat.sh
## Description: 本模块仅为公有云DNAT配置,配置仅支持ipv4场景。
## Created:     Friday, 1 15, 2021
################################################################################
logger  -p local0.info ""$(who -m | cut -d\( -f2 |cut -d\) -f1)"  ${BASH_SOURCE}; start;successfully excute ${BASH_SOURCE}"
declare rc_local_tmp=/etc/rc.d/rc.local_`date +%Y%m%d_%H%M%S`

################################################################################
# Function: uninstall
# Description: 去除生成iptables规则并本地化
# Parameter:
#   input:
#   $1: function name
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
#################################################################################
function uninstall()
{
    rmmod toa
    rm -f ${rc_local_tmp}
    sed '/modprobe toa/d' /etc/rc.d/rc.local > ${rc_local_tmp}
    mv ${rc_local_tmp} /etc/rc.d/rc.local -f
    chmod 755 /etc/rc.d/rc.local

    mid_ip=$1
    des_ip=$2
    port=$3
    iptables -t nat -D PREROUTING -p tcp -d ${mid_ip} --dport ${port} -j DNAT --to-destination ${des_ip}:${port}
    iptables -t nat -D OUTPUT -p tcp -m tcp -d ${mid_ip} --dport ${port} -j DNAT --to-destination ${des_ip}:${port}
    service iptables save
    rm -f ${rc_local_tmp}
    sed "s#iptables-restore -w < /etc/sysconfig/iptables#iptables-restore /etc/sysconfig/iptables#g" /etc/rc.d/rc.local > ${rc_local_tmp}
    mv ${rc_local_tmp} /etc/rc.d/rc.local -f
    chmod 755 /etc/rc.d/rc.local
}


################################################################################
# Function: install
# Description: 生成iptables规则并本地化，
# Parameter:
#   input:
#   $1: function name
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
#################################################################################
function install()
{
    uninstall "$@"

    modprobe toa
    echo 'modprobe toa' >> /etc/rc.d/rc.local

    mid_ip=$1
    des_ip=$2
    port=$3
    iptables -t nat -A PREROUTING -p tcp -d ${mid_ip} --dport ${port} -j DNAT --to-destination ${des_ip}:${port}
    iptables -t nat -A OUTPUT -p tcp -m tcp -d ${mid_ip} --dport ${port} -j DNAT --to-destination ${des_ip}:${port}
    service iptables save
    sed -i "s#iptables-restore /etc/sysconfig/iptables#iptables-restore -w < /etc/sysconfig/iptables#g" /etc/rc.d/rc.local
}


################################################################################
# Function: main
# Description: 根据参数执行对应的模块
# Parameter:
#   input:
#   $1: function name
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
#################################################################################
function main()
{
    if [[ "$1" == "install" ]];
    then
        logger -p local0.error ""$(who -m | cut -d\( -f2 |cut -d\) -f1)";param install, exit."
        echo "cmd install"
        install $2 $3 $4
    elif [[ "$1" == "uninstall" ]];
    then
        logger -p local0.error ""$(who -m | cut -d\( -f2 |cut -d\) -f1)";param uninstall, exit."
        echo "cmd uninstall"
        uninstall $2 $3 $4
    else
        logger -p local0.error ""$(who -m | cut -d\( -f2 |cut -d\) -f1)";param error, exit."
    fi
}


main "$@"
main_ret=$?
logger  -p local0.info ""$(who -m | cut -d\( -f2 |cut -d\) -f1)" ${BASH_SOURCE};end; successfully excute ${BASH_SOURCE}"
exit "$main_ret"
