#!/bin/bash
#针对需要修改网卡MTU值的场景
curpath=$(cd `dirname $0`; pwd)
cd $curpath
filename="allnic_mtu_modify.sh"
source /etc/profile
source /opt/tools/get_os_info.sh
LOG_INFO=info
LOG_ERR=err
avai_nic=""
select_nics=""
nic_count=


#check root user
function checkUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}

function do_exit()
{
	local num=$1
	if [ ${num} -ne 0 ]; then
		install_log ${LOG_ERR} "ERROR" "Modify MTU error."
	else
		install_log ${LOG_INFO} "SUCCESS" "MTU has modified successfully"
	fi
	exit ${num}
}

#获取系统是虚拟机还是物理机类型
function get_machine_type
{
	machine_type=`hostnamectl |grep Chassis | awk '{print $2}'`
	if [ ${machine_type} = "vm" ]; then
	    echo "machine type is vm."
	    return 0
	else
		echo "Unsupported machine type."
		do_exit 0
	fi
}

#检查用户输入的MTU的值是否满足要求
function checkMTUValue()
{
	echo ${mtu_value} | grep -E "^[0-9]+$" >/dev/null 2>&1
	if [ $? -ne 0 ]
	then
		echo "ERROR, Please input the right MTU value. [68-65535]"
		return 1
	fi
	
	if [ ${mtu_value} -lt 68 -o ${mtu_value} -gt 65535 ]
	then
		echo "ERROR, Please input the right MTU value. [68-65535]"
		return 1
	fi
	return 0
}

#记录系统日志
function install_log()
{
	type=$1
	tag=$2
	message=$3
	echo ${message}
	logger -p "local0.${type}" "${filename};  ${tag};  ${message}"
}

#---------------------------------------------------------------------------
#  Function:    modify_MTU
#  Description: modify_MTU
#  Input:       NA
#  Output:      NA
#  Return:      NA  
#  Others:      NA
#---------------------------------------------------------------------------
function modify_MTU
{  
    install_log ${LOG_INFO} "MODIFY" "Modifying MTU..."
	local flag="true"
	OLD_IFS="$IFS"
	IFS="," 
	local nics=(${select_nics})
        echo "${nics[@]}"
	IFS="$OLD_IFS"
	for item in ${nics[@]}; do
		ifconfig ${item} mtu ${mtu_value} > /dev/null 2>&1
		if [ $? -ne 0 ]
		then
			echo "ERROR Modify MTU of netcard \"${item}\" error. Typically this would be due to MTU value ${mtu_value} exceeding the maximum value supported by the interface hardware. Please reduce the MTU value ${mtu_value} of \"${item}\"."
			flag="false"
			break
		fi
		
		local netfile=${file_prefix}${item}

        if [ ! -f "${netfile}" ]
		then
			echo "DEVICE=\"${item}\"" >> ${netfile}
		fi

		cp -pf ${netfile} ${netfile}_bak > /dev/null 2>&1
		if [ $? -ne 0 ]
		then 
			echo "ERROR Backup configuration file of netcard \"${item}\" failed."
			flag="false"
			break
		fi
		
		sed -i '/^MTU/d' ${netfile}
		local flag1=$?
		echo "MTU='${mtu_value}'" >> ${netfile}
		local flag2=$?
		
		
		sed -i '/^DEVICE/d' ${netfile}
		local flag3=$?
		echo "DEVICE=\"${item}\"" >> ${netfile}
		local flag4=$?
		
		if [ ${flag1} -ne 0 -o ${flag2} -ne 0 ]
		then
			echo "ERROR Modify MTU of netcard \"${item}\" error."
			mv ${netfile}_bak ${netfile} > /dev/null 2>&1
			if [ $? -ne 0 ]
			then
				echo "ERROR Restore configuration file of netcard \"${item}\" error."
			fi
			flag="false"
			break
		fi
		
		
		rm -rf ${netfile}_bak > /dev/null 2>&1
		echo "INFO Modify MTU of netcard \"${item}\" successfully."
	done
	
	if [[ ${flag} != "true" ]];then
        return 1
    fi
	
	install_log ${LOG_INFO} "MODIFY" "Modifying MTU successfully."
	return 0
}

#打印可选网口
function show_port()
{
	if [ "${OS_TYPE}" = "suse" ]; then
		avai_nic=` ip addr |grep eth |grep -v "lo" | awk '{print $2}' | awk -F':$' '{print $1","}' | grep -v ":"`
	fi

	OLD_IFS="$IFS"
	IFS="," 
	local nics=(${avai_nic})
	nic_count=${#nics[@]}
	IFS="$OLD_IFS"
	local postfix=""
	local count=0
	local len=`expr ${nic_count} - 1`
	for i in $(seq 0 ${len}); do
		local item=${nics[${i}]}
		local nic=`echo ${item} | sed 's/[[:space:]]//g'`
		
		if [ ${i} -eq ${len} ]; then
			postfix=""
		else
			postfix=","
		fi
        if [ ! -f ${file_prefix}${nic} ]; then
			echo "ONBOOT=no" >> ${file_prefix}${nic}
		fi
		if [ -f ${file_prefix}${nic} ]; then
			count=`expr ${count} + 1`
			echo "${count}: ${nic}"
			avai_nic="${avai_nic}${count}:${nic}${postfix}"
            all_avai_nic+="${count}${postfix}"
		fi
	done
        
	nic_count=${count}
	if [ ${nic_count} -eq 0 ]; then
		echo "No valid nic found. exit"
		return 1
	fi
}

#检查用户输入项
function check_nics()
{
	content=$1
	echo "${content}" | grep -E "^[0-9,]+$" > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "invalid input: ${content}"
		return 1
	fi
	
	OLD_IFS="$IFS"
	IFS="," 
	local arr=(${content})
	local select_count=${#arr[@]}
	IFS="$OLD_IFS"
	local postfix=""
	local len=`expr ${select_count} - 1`
	local flag="true"
	local invalid_nics=""
	for i in $(seq 0 ${len}); do
		local item=${arr[${i}]}
		if [ ${item} -le 0 -o ${item} -gt ${nic_count} ]; then
			invalid_nics+="${item} "
			flag="false"
		fi
		if [ ${i} -eq ${len} ]; then
			postfix=""
		else
			postfix=","
		fi
		local nic=`echo ${avai_nic} | awk -F"${item}:" '{print $2}' | awk -F"," '{print $1}'`
		select_nics+="${nic}${postfix}"
	done
	
	if [ "${flag}" = "false" ]; then
		echo "invalid input: \"${invalid_nics}\""
		return 1
	fi
}

function main()
{
    checkUser || return 1
    file_prefix=""
    if [ "${OS_TYPE}" = "suse" ]; then
        file_prefix="/etc/sysconfig/network/ifcfg-"
    else
        echo "no need to modify mtu of os type:${OS_TYPE}"
        return 0
    fi

    #仅虚拟机需修改MTU值。
    machine_type=""
    get_machine_type || return 1

    echo "Current configured nics are as followed:"
    show_port || return 1

    #检查网口序号
    check_nics "${all_avai_nic}" || return 1

    mtu_value="1500"
    #检查MTU的值
    checkMTUValue ${mtu_value} || return 1

    install_log ${LOG_INFO} "INIT" "Start to modify MTU,it will cost about several seconds, Please don't interrupt!"

    install_log ${LOG_INFO} "MODIFY" "******************************<STEP 1: CHANGE CONFIGRATIONS>*******************"
    modify_MTU || return 1

    install_log ${LOG_INFO} "MODIFY" "******************************<STEP 1: CHANGE CONFIGRATIONS FINISH>************"

}


main
do_exit $?
