#!/bin/bash

################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    log_collect.sh
## Description: Search for processes that occupy a lot of resources.
################################################################################
declare -r LOG_FILE=/var/log/performance/performance_sop.log

################################################################################
# Function: syslog
# Description: Important operation must record to syslog
# Parameters :
#   input:
#   $1: message
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others: N/A
################################################################################
function syslog()
{
    local message=$1
    which logger >/dev/null 2>&1
    [ "$?" -ne "0" ] && return 0;
    logger -p local0.notice -i "${message}"

}

######################################################################
#   DESCRIPTION: 主函数
######################################################################
function main()
{
    syslog "Start to detect cpu and memory for node."
    date >> ${LOG_FILE}
    cat /proc/meminfo >> ${LOG_FILE}
    top -b -d 2 -n 4 >>${LOG_FILE}
    vmstat 1 4 >> ${LOG_FILE}
    iostat -x 1 4 >>${LOG_FILE}
    ps aux | grep -v "grep" | grep -v "pts/" >> ${LOG_FILE}
    sar -n DEV 1 4 >>  ${LOG_FILE}
    pidstat -d 2 5 >>   ${LOG_FILE}
    cat /proc/slabinfo  >>  ${LOG_FILE}
    /usr/sbin/ss -lt >>${LOG_FILE}
    netstat -s >>${LOG_FILE}
    chmod 600 ${LOG_FILE}
    /usr/sbin/logrotate /etc/logrotate.d/log_performance
    syslog "Success to detect cpu and memory for node."
    return 0
}

main $*
exit $?