#!/usr/bin/python
"""
Copyright ? Huawei Technologies Co., Ltd. 2021-2029. All rights reserved.
File name: // check_enviroment.py
Description: // get the enviroment nodeList and iplist.
function serving the file "pre_upgrade_MoveHFSFuseFile" "post_upgrade_MoveHFSFuseFile.sh".
"""

import json
import os

def main():
    oss_root = input()
    conffile = os.path.abspath(os.path.join(oss_root, 'etc', 'sysconf', 'nodelists.json'))
    node_ips = []
    with open(conffile, 'rb') as file:
        data = json.load(file)
    for k, v in data.get('nodeList', []).items():
        for item in v.get('IPAddresses', []):
            if 'maintenance' in item.get('usage', None):
                node_ips.append(item.get('IP'))
    all_list = "alllist="
    for ip in node_ips:
        if all_list == "alllist=":
            all_list = all_list + ip
        else:
            all_list = all_list + "," + ip
    print(all_list)
    file.close()
    return 0

if __name__ == '__main__':
    main()
