#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import os

sys.path.append(str(sys.argv[1]))
import codecs
from getDBConnection import get_zenith_session

def main():
    db_user = input()
    sql_file = input()
    curPath = os.path.dirname(os.path.abspath(__file__))
    exec_file = os.path.join(curPath, sql_file)
    db_session = get_zenith_session(db_user, db_user)
    if db_session is None:
        print("db_session %s is None" % db_user)
        return
    sql_txt = ''
    db_session.autocommit(True)
    db_cursor = db_session.cursor()
    with open(exec_file) as file_in:
        for line in file_in:
            if line.strip() == '':
                continue
            sql_txt = line.strip()
            try:
                db_cursor.execute(sql_txt)
                value = db_cursor.fetchall()
                print(value)
            except Exception as msg:
                print(msg)
    db_cursor.close()
    db_session.close()

if __name__ == '__main__':
    if len(sys.argv) != 2:
        print ('usage: exec_sql.py')
        sys.exit(-1)
    main()
