#!/bin/bash

SCRIPT_NAME=`basename $0`
LOG_FILE="/tmp/${SCRIPT_NAME}.log"

# 日志记录
function log()
{
    local msg=$1
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" |tee -a $LOG_FILE
}

# 校验入参
function check_input()
{
    if [ "${1}" == "-input" -a -n "${2}" ]
    then
        INPUT_PATH=${2}
    else
        log "ERROR The input param is invalid."
        exit 0
    fi
}

# 检查版本
function check_version()
{
    src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
    is_R21C00=`echo ${src_version} | grep V100R021C00`
    is_R21C10=`echo ${src_version} | grep V100R021C10`
    if [ -z "${is_R21C00}" ] && [ -z "${is_R21C10}" ]; then
        return 1
    fi
    log "src_version:[${src_version}] need enable cloudlicenseproxy"
    return 0
}

# 在某个节点起某个服务
function enable_service()
{
    local target_ip=$1
    log "Start to enable CloudLicenseProxy on ${target_ip}"
    local status=$(bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -tenant ${PRODUCTNAME} -app CloudLicenseProxy" -u ossadm -timeout 60 -encrypt N | tee -a ${LOG_FILE} 2>&1)
    echo ${status} | grep -qw "CloudLicenseProxy"
    if [ $? -eq 0 ]
    then
        bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd enable -app CloudLicenseProxy" -u ossadm -timeout 3600 -encrypt N | tee -a ${LOG_FILE} 2>&1
        if [ $? -ne 0 ]
        then
            log "Node ${target_ip}:Failed to enable CloudLicenseProxy."
            return 1
        fi
        bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd startapp -tenant ${PRODUCTNAME} -app CloudLicenseProxy" -u ossadm -timeout 3600 -encrypt N | tee -a ${LOG_FILE} 2>&1
        if [ $? -ne 0 ]
        then
            log "Node ${target_ip}:Failed to start CloudLicenseProxy."
            return 1
        fi
    fi
    log "Finished to enable CloudLicenseProxy on ${target_ip}"
}

# 在所有节点起某个服务
function enable_all_node_server()
{
    PRODUCTNAME=`cat ${INPUT_PATH}/plandata.json | grep productname | tr '"' ' ' | awk '{print $3 }'`
    SSHTOOL="${OSS_ROOT}/tools/common/sshmgr/sshmgr.sh"
    local NODELIST=$(cat "${INPUT_PATH}"/nodes_${PRODUCTNAME}.json 2>/dev/null | sed 's/,/\n/g'| grep nodemgrip | awk -F\" '{print $4}' 2>/dev/null)
    for nodeip in ${NODELIST}
    do
        enable_service "${nodeip}"
        if [ $? -ne 0 ]
        then
            log "Failed to enable CloudLicenseProxy."
            return 1
        fi
    done
}

# 检查入参
check_input "$@"
check_version
verMatch=$?
log "src_version match=${verMatch}"

. /opt/oss/manager/bin/engr_profile.sh
if [ ${verMatch} == 0 ]
then
    enable_all_node_server
fi

# 脚本执行完正常退出，不影响整个回退流程
exit 0