#!/bin/bash

##################################################
# 检查NCE各个节点时间是否一致，超过一分钟认为不一致，则报问题
##################################################

##################################################
# Description:  全局公共变量定义
# Parameters:   无
##################################################
function define_public() {
    # 目录
    LOGPATH="/opt/oss/log/manager/easysuite_upgrade/"
    # 文件
    LOGFILE="${LOGPATH}/check_time_sync.log"

    # 变量
    EULER_VR=""
}

##################################################
# Description:  创建目录文件
# Parameters:   无
##################################################
function create_public() {
    # 创建目录
    mkdir -p "${LOGPATH}"

    # 创建文件
    touch "${LOGFILE}"
}

##################################################
# Description:  日志打印
#               使用方法: log 日志级别 日志信息 [-nostd]
# Parameters:   日志级别: DEBUG、INFO、WARN、ERROR
#               日志信息: message
#               -nostd: 不显示到标准输出流，仅打印到日志文件
#Example:       log ERROR "message"
#               log INFO "message" -nostd
##################################################
function log() {
    # 接收参数
    local logtype=$1;
    local logmsg=$2;
    local nostd=$3;

    # 当前时间
    local datetime=$(date +'%F %T')

    # 函数调用
    local fncall=""

    # 代码行位置
    local line=""

    # 级别颜色
    case "${logtype}" in
        DEBUG)
            logtype="\033[35m${logtype}\033[0m" ;;
        INFO)
            logtype="\033[36m${logtype}\033[0m" ;;
        WARN)
            logtype="\033[33m${logtype}\033[0m" ;;
        ERROR)
            logtype="\033[31m${logtype}\033[0m" ;;
    esac

    # 有错显示函数调用及代码行位置
    if [[ "${logtype}" =~ "ERROR" ]] || [[ "${logtype}" =~ "WARN" ]];then
        fncall="${FUNCNAME[@]/log/}"
        line="[line:$(caller 0 | awk '{print$1}')]"
    fi

    # 日志格式
    logformat="${datetime} ${logtype} ${fncall} ${line} ${logmsg}"

    # 日志输出
    [ "${nostd}" = "-nostd" ] && echo -e "${logformat}" >> "${LOGFILE}" || echo -e "${logformat}" | tee -a "${LOGFILE}"
}

function get_node_ip()
{
    . /opt/oss/manager/bin/engr_profile.sh
    cat /opt/oss/manager/etc/sysconf/nodelists.json  | python -c "import json;
NODELISTS_FILE_PATH = '/opt/oss/manager/etc/sysconf/nodelists.json'
node_ip_list = []

with open(NODELISTS_FILE_PATH, 'r') as file_obj:
    data = json.load(file_obj)

for node in data.get('nodeList').values():
    hostname = node.get('hostname')
    for ip in node.get('IPAddresses'):
        if 'maintenance' in ip.get('usage'):
            node_ip_list.append(ip.get('IP'))

res_ip_list = str(node_ip_list).replace('\'', '').replace('[', '').replace(']', '').replace(' ', '')
print(res_ip_list)"
}

function check_time_sync()
{
    log INFO "********** Start to execute the check_time_sync() **********\n" -nostd
    node_ip_list=`get_node_ip`
    log INFO " node_ip_list : $node_ip_list \n" -nostd
    OLD_IFS="$IFS"
    IFS=","
    arr=($node_ip_list)
    IFS="$OLD_IFS"
    if [[ ${#arr[@]} -eq 1 ]]; then
       log INFO " The current environment is a single node. No check is required.\n" -nostd
       return 0
    fi
    current_node_date=`date +%s`
    for node_ip in ${arr[@]}
    do
       date_res=`ssh $node_ip "date +%s"` >/dev/null 2>&1
       if [[ $? -eq 0 ]]; then
          sub_res=`expr $date_res - $current_node_date`
          if [[ $sub_res -gt 60 ]]; then
              node_name=`ssh $node_ip "hostname"` >/dev/null 2>&1
              log ERROR " The time difference of the current node exceeds 1 minute. node name is : $node_name , node ip is : $node_ip \n" -nostd
              return 1
          fi
       else
          log ERROR " this command \" ssh $node_ip 'date +%s'\" execute failed. \n" -nostd
          return 1
       fi
    done

    return 0
}

function main() {
    define_public || return 1
    create_public || return 1
    check_time_sync "$@"
    return $?
}

main "$@"
exit $?
