#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)

function main()
{
    # 加载公共方法
    . ${SCRIPT_PATH}/operate_schedule.sh
    config_dir="/opt/oss/log/manager/easysuite_upgrade_config"
    [ ! -e "${config_dir}" ] && mkdir -p "${config_dir}"
    thread_pool_file="${config_dir}/shell_thread_pool"
    [ -f ${thread_pool_file} ] && return 0
    [ ! -f ${thread_pool_file} ] && touch ${thread_pool_file}
    workpath=$(echo $@ | awk -F' ' '{print $2}' | awk -F '/' '{for(i=1;i<=NF;++i) print $i}' | grep 'V100' | sed 's/-/_/g')
    script_id="0"
    python ${pyscript} "enable" "${workpath}" "${script_id}"
    rm -rf ${thread_pool_file}
}
main "$@"
exit $?
