#!/bin/bash
#检查所有节点上是否存在/opt/signtool目录，不存在则创建（扩容后可能会删除，导致欧方升级失败）

function get_all_nodes_ip()
{
    . /opt/oss/manager/bin/engr_profile.sh
    nodes_ip=$(python <<EOF
import os
import json

nodelist_file=os.path.join(os.getenv("INSTALL_ROOT", "/opt/oss"), "manager", "etc", "sysconf", "nodelists.json")
with open(nodelist_file) as f:
    data=json.load(f)

nodes_ip_list = []
for _, node in data['nodeList'].items():
    for ip_info in node['IPAddresses']:
        if 'maintenance' in ip_info['usage']:
            nodes_ip_list.append(ip_info['IP'])
            break

nodes_ip_str = " ".join(nodes_ip_list)
print(nodes_ip_str)
EOF
)
}

function exec_sudo_cmd()
{
    #获取产品名
    product_name=$(grep -Po 'productname[" :]+\K[^"]+'  "${2}"/plandata.json)

    #升级提权包路径
    sudobin_pkg_path="/opt/upgrade/easysuite_upgrade/scripts/common/NCE-Common/upgrade_sudo_pkg/sudobin_pkg.tar"
    if [ ! -f ${sudobin_pkg_path} ]
    then
        echo "upgrade sudobin package is not exist."
        return 1
    fi

    #提权脚本临时路径
    tmp_uuid=$(cat /proc/sys/kernel/random/uuid)
    tmp_sudo_path="/opt/tmp_sudo_${tmp_uuid}"
    echo ${tmp_sudo_path}

    #提权scp路径
    scp_path="/home/ossadm/${product_name}"

    get_all_nodes_ip
    for nodeip in ${nodes_ip}
    do
        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} 'mkdir -p '${scp_path}'' &>>/dev/null
        if [ $? -ne 0 ]
        then
            echo "mkdir ${scp_path} on node ${nodeip} failed."
            return 1
        fi

        # 只有scp命令区分ipv6
        echo "${nodeip}" | grep -q ":"
        if [ $? -ne 0 ]
        then
            # ipv4
            scp -o StrictHostKeyChecking=no ${sudobin_pkg_path} ossadm@${nodeip}:${scp_path}
        else
            # ipv6
            scp -o StrictHostKeyChecking=no ${sudobin_pkg_path} ossadm@[${nodeip}]:${scp_path}
        fi
        if [ $? -ne 0 ]
        then
            echo "scp sudobin package to node ${nodeip} failed."
            return 1
        fi

        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} 'sudo /usr/local/uniepsudobin/execute.sh '${scp_path}'/sudobin_pkg.tar '$tmp_sudo_path' resolve_previous_version_issues.sh' &>>/dev/null
        if [ $? -ne 0 ]
        then
            echo "execute create_signtool_path.sh on node ${nodeip} failed."
            return 1
        fi

        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} 'rm -rf '${scp_path}'' &>>/dev/null
        if [ $? -ne 0 ]
        then
            echo "clear ${scp_path} on node ${nodeip} failed."
            return 1
        fi
    done
    return 0
}

exec_sudo_cmd "$@"
exit $?