# -*- coding:utf-8 -*-
"""
功 能：产品运维面升级二段式升级第一段
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2021-01-11 17:00 创建
"""
import json
import os
import sys
import threading
import time

from commonlog import Logger
from operate_product import Operateproduct
from operate_product_util import OperateProductUtil
from taskmgr_util import Taskmgrutil

INDEX_OF_ARGV_ONE = 1
INDEX_OF_ARGV_TWO = 2
INDEX_OF_ARGV_THREE = 3
INDEX_OF_ARGV_FOUR = 4
INDEX_OF_ARGV_FIVE = 5
INDEX_OF_ARGV_SIX = 6
INDEX_OF_ARGV_SEVEN = 7
INDEX_OF_ARGV_EIGHT = 8
INDEX_OF_ARGV_NINE = 9
INDEX_OF_ARGV_TEN = 10
IENGTH_OF_ARGV_THIRTEEN = 13

logger = Logger().getinstance(sys.argv[0])

INFO = "INFO"
WARN = "WARNING"
ERROR = "ERROR"


class TaskStatus:
    initial = "INITED"

    running = "DEPLOYING"

    error = "DEPLOY_FAILED"

    finish = "DEPLOY_SUCCESS"


class OperateproductFirstPhase(Operateproduct):
    """
    产品部署失败状态只有重试场景可以进入
    初次创建任务不支持部署失败状态直接部署产品
    """
    def gen_upgrade_params(self, param_dict, target_version, packages):
        # sysProperties：部署控制配置项，properties：业务配置项
        upgrade_params = {}
        # easysuite框架自动适配二段式升级isSegmentUpgrade参数
        logger.info("gen_upgrade_params upgrade_start_policy: %s" % self.upgrade_start_policy)
        upgrade_params.update({'configs': {'sysProperties': [
            {'name': 'startupPolicy', 'value': self.upgrade_start_policy, 'type': 'string'},
            {'name': 'deployType', 'value': 'UPGRADE', 'type': 'string'}], 'properties': [
            {'name': 'isSegmentUpgrade', 'value': 'true', 'type': 'string'}]}})
        upgrade_params.update({'packages': packages})
        for item in param_dict.get("parameters"):
            upgrade_params['configs']['properties'].append(item)
        return upgrade_params

    def retry_product(self, task_id_path):
        product_info = self.query_product_info()
        deploy_id = product_info.get("deployId")
        product_id = product_info.get("productId")
        logger.info("[function_name:%s] product_deployid:%s" % (
            self.get_function_name(), deploy_id))
        deploy_status = product_info.get("deploy_status")
        if deploy_status == TaskStatus.error:
            status, response = self.unieptask_function.send_put_request(
                self.retry_product_url % (deploy_id, self.productname))
            if status is False:
                return 1
            # 查询进度等待任务执行完成
            self.wait_product_task(response, product_id, deploy_id, task_id_path, True)
            return 0
        return 2

    def query_firstphase_result(self, deploy_id):
        status, response = self.unieptask_function.send_get_request(
            self.query_deploy_msg_url % deploy_id)
        if status is False:
            self.do_exist_error("Failed to send upgrade request(%s) to manager."
                                % self.query_deploy_msg_url % self.productname)
            return False
        response_content = response.decode().strip()
        if response_content.endswith("The first phase of the upgrade is complete."):
            return True
        return False

    def upgrade_product_firstphase(self, target_version, task_id_path, product_pkgs, offline_pkgs, parallel_installation):
        """
        功能描述：二段式升级产品第一段
        参数：
        返回：
        修改记录：新增方法
        """
        self.product_pkgs = product_pkgs
        taskmsg = os.path.join(task_id_path, "task.log")

        # 查询产品信息
        params_dict = self.query_product_info()
        product_deployid = params_dict.get("deployId")

        if OperateproductFirstPhase.query_firstphase_result(self, product_deployid):
            Taskmgrutil.set_e_taskprogress(task_id_path, "100")
            Taskmgrutil.set_e_taskstatus(task_id_path, "success")
            self.print_msg(INFO, "The first phase of the upgrade is already complete.")
            return True

        ret_code = self.retry_product(task_id_path)
        if ret_code == 0:
            return True
        elif ret_code == 1:
            return False

        # 执行子域定制脚本
        result = self.get_domain_config(offline_pkgs)
        if not result:
            self.do_exist_error("Failed to get domain config.")
            return False

        params_dict.update({"parameters": self.deploy_params})
        params_dict.update({"features": self.features})
        params_dict.update({"upgrade_start_policy": self.upgrade_start_policy})
        params_dict.update({"parallelInstallation": parallel_installation})
        upgrade_deploy_data = {"target_version": target_version}
        upgrade_deploy_data.update({"packages": self.deploy_pkgs})
        upgrade_data = OperateProductUtil.build_upgrade_data(params_dict, target_version,
                                                             self.deploy_pkgs)

        result = self.pre_upgrade_product(params_dict, upgrade_deploy_data, task_id_path)
        if result in [True, False]:
            return result

        # 调整分段升级参数
        upgrade_params = self.gen_upgrade_params(params_dict, target_version, self.deploy_pkgs)

        # 从upgrade_params取isSegmentUpgrade的值
        properties = upgrade_params['configs']['properties']
        for item_properties in properties:
            if item_properties['name'] != 'isSegmentUpgrade':
                continue
            issegement = item_properties['value']
            # 分段升级
            if not(issegement is not None and issegement == 'true'):
                return False

        # 执行第一段
        self.print_msg(INFO, "Start to execute the first phase of the upgrade.(%s)" %
                       self.productname)

        # 记录开始时间
        ipmc_tool_start_time = time.time()
        # 创建并启动任务线程
        ipmc_tool_thread = threading.Thread(target=self.ipmc_tool_upgrade_product_firstphase,
                                            args=(upgrade_data, taskmsg, self.plandata_path), name="child-thread-0")
        ipmc_tool_thread.start()
        # 收集任务信息
        ipmc_tool_thread_tasks_data = {
            "upgrade_product": {
                "thread": ipmc_tool_thread, "operation": "Upgrade Product Firstphase", "countdown": 0}}
        # 监控任务进度
        self.monitor_tasks(ipmc_tool_thread_tasks_data, ipmc_tool_start_time, "IPMC")
        if not self.upgrade_product_status:
            time.sleep(5)
            self.set_task_data(self.task_id_path, "error", "100")
            return False
        self.set_task_data(self.task_id_path, "finish", "100")
        return True

    def ipmc_tool_upgrade_product_firstphase(self, upgrade_data, task_detail, work_path):
        """
        封装ipmc_tool_upgrade_product调用方法
        """
        status, is_deploy_task_created = OperateProductUtil. \
            ipmc_tool_upgrade_product_firstphase(upgrade_data, task_detail, work_path)

        # 部署任务创建后，记录产品名和deploy_id
        if is_deploy_task_created:
            params_dict = self.query_product_info()
            deploy_id = params_dict.get("deployId")
            rollback_check_json = os.path.join(work_path, "rollback_check.json")
            input_data = {
                "productName": self.productname,
                "deployId": deploy_id
            }
            with open(rollback_check_json, "w") as file:
                file.write(json.dumps(input_data))
            logger.info(f"Generate rollback_check.json for deploy task, file path: {work_path}")

        if status is False:
            self.upgrade_product_status = False
            return self.upgrade_product_status
        self.upgrade_product_status = True
        return self.upgrade_product_status


def main(argv):
    params = OperateProductUtil.format_params(argv)
    script_id = params.get("script_id")
    e_task_path = os.path.join("/opt/upgrade/easysuite_upgrade/taskmgr", script_id)
    if not OperateProductUtil.is_path_valid(script_id):
        logger.error("script_id %s is invalid" % script_id)
        return False
    params.update({"task_id_path": e_task_path})

    product_pkgs = params.get("product_pkgs")
    offline_pkgs = params.get("offline_pkgs", "")
    upgrade_start_policy = params.get("upgrade_start_policy", "")
    parallel_installation = params.get("parallel_installation", "")
    params.update({"upgrade_start_policy": upgrade_start_policy})
    operate_function = OperateproductFirstPhase(params)
    result = operate_function.fresh_omp_json("fresh")
    if not result:
        return
    operate_function.upgrade_product_firstphase(params.get('des_version'),
                                                params.get('task_id_path'),
                                                product_pkgs, offline_pkgs, parallel_installation)
    result = operate_function.fresh_omp_json("recover")
    if not result:
        return


if __name__ == '__main__':
    main(sys.argv)
