# encoding=utf-8
import os
import sys

from util import ossext


def main(argv):
    """
    :param argv:脚本入参
    """
    # 入参
    file_path = argv[1]
    reboot_pwd = input("reboot_pwd\n")

    # 保存临时密文
    save_reboot_pwd(file_path, reboot_pwd)


def save_reboot_pwd(file_path, reboot_pwd):
    """
    保存临时密文到临时文件
    :param file_path: 文件路径
    :param reboot_pwd: 输入密码
    """
    for i in range(3):
        try:
            # 平台加密方法
            en_reboot_pwd = ossext.Cipher.encrypt(reboot_pwd)

            # 写入文件
            with os.fdopen(os.open(file_path,
                                   os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                                   mode=0o600), "w", encoding='utf-8') as file:
                file.write(en_reboot_pwd)
            sys.exit(0)
        except Exception as e:
            print(f"Failed to encrypt reboot_pwd, retry time: {i}")
            continue
    sys.exit(1)


if __name__ == '__main__':
    main(sys.argv)
