#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"
CLOUDSOP_PROFILE=

##################################################
# 校验执行用户
# 脚本要求使用root用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    # 外部输入参数数量
    input_params_num=4
    if [ $# -ne ${input_params_num} ]
    then
        return 1
    fi

    # 任务唯一ID
    TASKID="${1}"
    # 产品名称
    PRODUCT_NAME="${2}"
    # 源版本
    SRC_VERSION="${3}"
    # 目标版本
    DES_VERSION="${4}"
}

# 处理任务打印
function record_es_log()
{
    LOG_PRINT "${1}" "${2}" >>"${TASK_LOG_FILE}"
}

# CloudSop切KMC,关闭KMC保护（pwd）开关
function close_kmc_pwd()
{
    python <<END
import sys
import json
import time
from util import httpclient
def send_post(url, params, check_key=None):
    for _ in range(0, 30):
        status, response = httpclient.IRHttpClient().post(request_url, params)
        if status == 200 and check_key is None:
            print(status, response)
            break
        if status == 200 and check_key and json.loads(response).get(check_key):
            print(status, response)
            break
        print("Try:", _, status, response)
        time.sleep(1)
    return status, response
request_url = "/rest/plat/engrcommonwebsite/v1/commissioning/silence/protectlocalkey"
params = {"actionkey": "replaceDataSignProtectPvalue","datalist": [{"oldProtectPad": "", "newProtectPad": ""}]}
status, response = send_post(request_url, params, check_key="taskid")
if status != 200 or not json.loads(response).get("taskid"):
  sys.exit(1)
res_data = json.loads(response)
task_id = res_data.get('taskid')
results = res_data.get('results')
for res in results:
    if res.get('status', 0) == -1:
        sys.exit(1)

query_params =  {"datalist": [{"taskid": task_id}], "actionkey": "queryProgress"}
# 正常最多执行15分钟
for _ in range(0, 900):
    status, response = send_post(request_url, query_params)
    # 失败退出
    if status != 200:
        sys.exit(1)
    time.sleep(1)
    res_data = json.loads(response)
    # 继续查询
    if status == 200 and res_data.get('status', 0) != 0:
        continue
    # 结束查询
    if status == 200 and res_data.get('progress', 0) == 100:
        if res_data.get('results') and res_data.get('results')[0].get('status', 0) == -1:
            sys.exit(1)
        break
else:
    sys.exit(1)
sys.exit(0)
END
}

# 下发kmc切换命令
function switch_kmc_cmd()
{
    local failed_flag="${1}"
    if [ -f "${failed_flag}" ]
    then
        osskey -cmd SwitchKmc -force -mode security -retry >>"${TASK_LOG_FILE}"
    else
        osskey -cmd SwitchKmc -force -mode security >>"${TASK_LOG_FILE}"
    fi
}

# 固定等待1分钟
function sleep_for_one_minute()
{
    for percent in {0..100}
    do
        record_es_log "INFO" "Wait product on node:[0] ----------- ${percent}%"
        sleep 0.6
    done
}

function switch_kmc()
{
    # 命令单次任务执行结果文件
    local failed_flag="${LOG_PATH}/${TASKID}.fail.flag"
    local protectpwd_flag="${LOG_PATH}/${TASKID}.protectpwd.flag"
    # 标志文件判断
    flag_file="${SCRIPT_PATH}/${SELF_FILE//.sh/}${RANDOM}"
    # ossadm: 创建工作路径
    config_path="${WORK_PATH}/${SRC_VERSION}-${DES_VERSION}/workpath-${PRODUCT_NAME}/pre_upgrade"
    # 生成文件配置
    config_file="${config_path}/pre_upgrade_config.properties"
    grep -q "kmc_mode_manager=true" "${config_file}"
    if [ $? -eq 0 ]
    then
        record_es_log "INFO" "Already in kmc mode.Skip current step."
        return 0
    fi
    record_es_log "INFO" "Start to switch to kmc mode"
    . ${CLOUDSOP_PROFILE}
    # 标志文件不存在,说明没有走到保护密码重置，那么需要走KMC切换
    if [ ! -f "${protectpwd_flag}" ]
    then
      # 标志文件判断法
        rm -f "${flag_file}" &>/dev/null
        # 核心任务挂起
        (switch_kmc_cmd "${failed_flag}";echo "$?" >"${flag_file}" )&

        # 刷新进度,并给出进程失败返回码
        fresh_task_progress "${TASKID}" "10" "${flag_file}" "0" "60"
        result=$?
        if [ ${result} -ne 0 ]
        then
            [ ! -f "${failed_flag}" ] && echo retcode=${result} > "${failed_flag}"
            record_es_log "INFO" "Failed to switch to kmc mode"
            return 1
        fi
    fi
    record_es_log "INFO" "Finished to switch to kmc mode"
    record_es_log "INFO" "Start to reset kmc data"
    # 标志文件判断法
    rm -f "${flag_file}" &>/dev/null
    # 核心任务挂起
    (close_kmc_pwd &>>"${LOG_FILE}";echo "$?" >"${flag_file}" )&

    # 刷新进度,并给出进程失败返回码
    fresh_task_progress "${TASKID}" "5" "${flag_file}" "60" "90"
    result=$?
    if [ ${result} -ne 0 ]
    then
        [ ! -f "${protectpwd_flag}" ] && echo retcode=${result} > "${protectpwd_flag}"
        record_es_log "INFO" "Failed to reset kmc data"
        return 1
    fi
    record_es_log "INFO" "Finished to reset kmc data"
    [ -f "${failed_flag}" ] && rm -f "${failed_flag}"
    [ -f "${protectpwd_flag}" ] && rm -f "${protectpwd_flag}"
    # R22C00临时规避,固定等待1分钟
    sleep_for_one_minute
    return 0
}

function main()
{
    # 加载公共方法
    . ${SCRIPT_PATH}/common.sh
    LOG "INFO" "Start to init ${LOG_FILE}."
    init_params "$@" || return 1
    # 初始化升级任务
    init_taskmgr "${TASKID}"
    TASK_LOG_FILE="${TASK_MGR_PATH}/${TASKID}/task.log"
    fresh_es_progress "${TASKID}" "1"
    switch_kmc
    if [ $? -ne 0 ]
    then
        do_exit "${TASKID}"
        return 1
    fi
    fresh_es_status "${TASKID}" "success"
    fresh_es_progress "${TASKID}" "100"
}

main "$@" &
exit 0
