#!/bin/bash

echo -n "es_input: ip"
read ip

echo -n "es_input: sopuser_passwd"
read -sr sopuser_passwd

echo -n "es_input: ossadm_passwd"
read -sr ossadm_passwd

echo -n "es_input: root_passwd"
read -sr root_passwd

echo -n "es_input: port"
read port

. /opt/oss/manager/bin/engr_profile.sh

function update_arbitration()
{
    local output=$((echo "${ip}"; echo "${port}"; echo "${root_passwd}"; echo "${ossadm_passwd}"; echo "${sopuser_passwd}";) | python -c "from util import common, httpclient
import json
ip = input()
port = input()
root_passwd = input()
ossadm_passwd = input()
sopuser_passwd = input()
client = httpclient.IRHttpClient()
url = '/rest/smpmanagerservice/v1/healthcheck/updateArbitration'
params = {
    'ip': ip,
    'port': port,
    'rootPasswd': root_passwd
}
if ossadm_passwd:
    params['ossadmPasswd'] = ossadm_passwd
if sopuser_passwd:
    params['sopuserPasswd'] = sopuser_passwd
code, response = client.post(url, params)
if code == 200:
    try:
        result = json.loads(response).get('result', -1)
        print(f'{code}: success')
        exit(result == 1)
    except Exception as _:
        print(f'{code}: parse result failed')
        exit(1)
if code == 503:
    print(f'{code}: /rest/smpmanagerservice/v1/healthcheck/updateArbitration is not available')
    exit(2)
print(f'{code}: update arbitration failed')
exit(1)
"
)
    local result=$?
    echo "${output}"
    return ${result}
}

function main()
{
    for count in {0..4}
    do
        update_arbitration
        return_code=$?
        if [ ${return_code} -eq 2 ]
        then
            # 503重试，5秒一次，最多5次
            sleep 5
            continue
        elif [ ${return_code} -eq 0 ]
        then
            return 0
        fi
        return 1
    done
}

main