#!/bin/bash
SELF_FILE=$(basename $0)

#################################
# 检查脚本ID
#################################
function check_script_pid()
{
    local script_id="${1}"
    for count in {0..1}
    do
        ps -ef | grep -v grep | grep -v ${SELF_FILE} | grep -q ${script_id}
        if [[ $? -eq 0 ]]
        then
            return 0
        fi
        if [ ${count} -eq 1 ]
        then
            break
        fi
        sleep 1
    done
    return 1
}

#################################
# 检查任务是否执行结束
#################################
function check_task_end()
{
    local script_id="${1}"
    local task_mgr_path=${2}
    local task_status="${task_mgr_path}/${script_id}/task.status"
    # "finish", "success", "failed", "fail", "error"
    [ -f "${task_status}" ] && grep -iqE "status=finish|status=success|status=failed|status=fail|status=error" "${task_status}" && return 1
    return 0
}

#################################
# 主入口
#################################
function main()
{
    check_script_pid ${1}
    if [[ $? -ne 0 ]]
    then
        check_task_end ${1} ${2} ${3}
        if [[ $? -ne 0 ]]
        then
            echo -n easysuite.upgrade.cmd.finish 1>&2
            return 1
        fi
        echo -n easysuite.upgrade.cmd.fail 1>&2
        return 1
    fi
    return 0
}

main "$@"
exit $?

