#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################

SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

function check_param()
{
	local para=$1
	echo "$para" | grep -q -E '^[ 0-9a-zA-Z./:_-]'
	result=$?
	if [ "$result" -ne 0 ]
	then
        	echo "parameter error!"
        	exit 1
	fi
}

function init_param()
{	
	DB_PATH=$1
	check_param "${DB_PATH}" || return 1
	CLONE_DB_PATH=$2
	check_param "${CLONE_DB_PATH}" || return 1
	TMP_FILE=$DB_PATH'/csvfile'
	DB_FILE=$DB_PATH'/easysuite.sqlite3'
	DB_CLONE_FILE=$CLONE_DB_PATH'/easysuite.sqlite3'
}

function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}


function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
}


function clone_db()
{
	[ ! -d ${TMP_FILE} ] && mkdir ${TMP_FILE} 

	tables=`sqlite3 ${DB_FILE} ".tables"`
	arr=($tables)
	LOG "INFO" "tables: ${tables}"

	sqlite3 ${DB_FILE} <<- EXIT_HERE 
	.output sqltmp.sql 
	.dump 
	.output stdout
	.exit
	EXIT_HERE

	for s in ${arr[@]}
	do
		sqlite3 ${DB_CLONE_FILE} <<- EXIT_HERE
		delete from ${s};
		.exit
		EXIT_HERE
	done
	
	sqlite3 ${DB_CLONE_FILE} <<- EXIT_HERE
	.read sqltmp.sql
	.exit
	EXIT_HERE
        
	rm -f sqltmp.sql
}

function main()
{
	check_user || return 1
	init_param "$@" || return 1
	clone_db
	return $?
}

main "$@"
exit $?
