#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: install_mellanox.sh
# Description: 安装Mellanox驱动，重启网络，重启DPDKAgent
###############################################################################

CUR_PATH=$(cd `dirname $0`;pwd)
logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1)  [install mellanox driver]Start updating mellanox driver"
echo "Start updating mellanox driver"
ls "$CUR_PATH"/kmod-mlnx-ofa_kernel-* &>/dev/null
if [ $? != 0 ];
then
  echo "please upload package of Mellanox"
  exit
fi

ls "$CUR_PATH"/libibverbs* &>/dev/null
if [ $? != 0 ];
then
  echo "please upload package of Mellanox"
  exit
fi


libibverbsRpmName=$(ls -l |grep "libibverbs-" |grep -v "utils" |awk '{print $9}')
echo "install $libibverbsRpmName"
rpm -ivh --force --nodeps "$libibverbsRpmName"

kmodRpmName=$(ls -l |grep kmod-mlnx-ofa |awk '{print $9}')
echo "install $kmodRpmName"
rpm -ivh --force --nodeps "$kmodRpmName"

modprobe -r mlx5_ib
modprobe -r mlx5_core
modprobe -r ib_uverbs

koLocationExample=$(rpm -ql "$kmodRpmName" 2> /dev/null |grep "/lib/modules" |tail -1)
koLocationBase="${koLocationExample%extra*}"
cp -r "$koLocationBase""/extra/mlnx-ofa_kernel" "/lib/modules/""$(uname -r)""/extra"
depmod -a

modprobe ib_uverbs
modprobe mlx5_core
modprobe mlx5_ib

modinfo mlx5_core |grep version

echo "Mellanox driver updated successfully"

service network restart

su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd restartapp -app DPDKAgent"
logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1)  [install mellanox driver]Mellanox driver updated successfully"


