#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${current_path}/../../cmd.backup_redis_aof_local.log"
    return 0
}
function fn_get_all_log_file_path()
{
    echo "${current_path}/../../cmd.backup_redis_aof_local_all.log"
    return 0
}

###############################################################################################
function fn_init()
{
    readonly current_path=$(dirname $(readlink -f $0 ))

    # Loading Modules
    source ${current_path}/../utils/load_all_util.sh
    readonly c_root_path=$(cd ${current_path}/../../ && pwd && cd - &>/dev/null)
    # Initialization Log
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"

    readonly c_log_file="$(fn_get_log_file_path)"
    readonly fi_install_path="/opt/huawei/Bigdata"
    readonly local_ip_addr=$(hostname -i)
    readonly redis_instance_num=10

    # save history log file
    readonly all_log_file="$(fn_get_all_log_file_path)"
    fn_sys_create_log_file "$all_log_file"
    [ -f "${c_log_file}" ]  && cat "${c_log_file}" >> ${all_log_file}

    [[ -f ${c_log_file} ]] && rm -f ${c_log_file}
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"
    source "${c_root_path}/shscript/profile/upgrade_profile.sh"

    return 0
}

###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    [[ "$(fn_sys_is_valid_ip ${local_ip_addr})" == "false" ]] && fn_sys_log_error "${local_ip_addr} is not a valid IP address." && return 1
    fn_sys_assert_is_directory "fi_install_path" || fn_sys_log_error "The node is not the node where the FusionInsight is installed." || return 1

    readonly redis_cli_path=$(ls /opt/huawei/Bigdata/components/FusionInsight_HD_*/Redis/client/bin/redis-cli)

    return 0
}


###################################################
#
# 判断是否是master实例的命令
#
###################################################
function cmd_is_master()
{
    local ip_addr="$1"
    local port="$2"
    su - omm -c "${redis_cli_path} -h $ip_addr -p $port info replication | grep 'role' | awk -F ':' '{print \$2}'"
}


###################################################
#
# 判断是否是master实例
#
###################################################
function fn_is_master_instance()
{
    local ip_addr="$1"
    local port="$2"
    local result=$( echo `cmd_is_master $ip_addr $port` | grep "master" )
    [ "$result" != "" ] && return 0
    return 1
}


###################################################
#
# 判断是否是master实例
#
###################################################
function fn_bgrewriteaof() {

    local need_count=0
    for i in $(seq 1 $redis_instance_num)
    do
        port=$((22399+$i))
        fn_is_master_instance ${local_ip_addr} ${port}
        [ "$?" -eq 1 ] && fn_sys_log_info "${local_ip_addr}:${port} is not master instance skip" && continue
        fn_sys_log_info "${local_ip_addr}:$port is master"
        need_count=$((need_count+1))
        fn_sys_log_info "This is NO.${need_count} aof files."
        su - omm -c "${redis_cli_path} -h ${local_ip_addr} -p ${port} -c bgrewriteaof"
        [ "$?" -eq 0 ] && sleep 30 && [ -f "/srv/BigData/redis/Redis_$i/appendonly.aof" ] && su - omm -c "cp /srv/BigData/redis/Redis_$i/appendonly.aof ${aof_backup_path}/appendonly-${local_ip_addr}-$((22399+$i)).aof"
    done

    real_count=$(ls ${aof_backup_path} | wc -l)
    fn_sys_log_info "Number of files that should be detected ${need_count}."
    fn_sys_log_info "Actual Number of Files Detected ${real_count}."

    [[ ${need_count} != ${real_count} ]] && fn_sys_log_error "Unexpected number of files detected" && touch ${aof_flag_path} && return 1

    touch ${aof_flag_path}
    return 0
}


###################################################
#
# 检查是否每个节点都有aof文件，创建flag。
#
###################################################
function fn_check_result() {

    return 0
}

###############################################################################################
function fn_do()
{
    # check first
    fn_precheck || return 1

    # mkdir tmp backup path
    [ -d ${aof_backup_path} ] && su - omm -c "rm -rf ${aof_backup_path}"
    su - omm -c "mkdir -p ${aof_backup_path}"
    fn_bgrewriteaof || return 1

    return 0
}

###############################################################################################
function fn_main()
{
    readonly c_start_time="$(date +%s)"
    fn_init
    fn_sys_log_info "Start to backup redis aof data."
    fn_do
    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_info "Leave post_install with status [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    [[ ${l_result} -ne 0 ]] && fn_sys_log_error "Failed to run backup redis."
    return "$l_result"
}

###############################################################################################

fn_main "$@"
result="$?"
exit "$result"
