#!/bin/bash
logger -t $USER -p local0.info "${OPERIP:-127.0.0.1};Start osconfig uninstall.sh script"
#get absolute path
FileName="`basename $0`"
RELATIVE_PATH="$(dirname $0)"
cd "${RELATIVE_PATH}"
ABSOLUTELY_PATH=`pwd`
cd - &> /dev/null

USER=`whoami`
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
[ -z "${WORK_USER}" ] && WORK_USER='ossadm'
if [ "${USER}" != "ossadm" -a "${USER}" != "admrunuser" ]
then
    echo "Only ossadm or admrunuser can run this command."
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Only ossadm or admrunuser can run this command."
    exit 1
fi

if [ ! -d  /usr/local/osconfig ]
then
    echo "Uninstall osconfig package done."
    exit 0
fi


function fn_main()
{
    [ "${USER}" != "${WORK_USER}" ] && { sudo -u "${WORK_USER}" bash /usr/local/osconfig/os/bin/uninstall_osconfig.sh $@; return $?; }
    bash /usr/local/osconfig/os/bin/uninstall_osconfig.sh $@
    return $?
}

fn_main "$@"
RET_MAIN=$?
logger -t $USER -p local0.info "${OPERIP:-127.0.0.1};End to osconfig uninstall.sh script"
exit ${RET_MAIN}
