#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]; then
    echo "please login as arbiter, then excute the script again."
    exit 1
fi

function get_work_path() {
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir | awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]; then
        local dir=$(echo ${dir} | sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]; then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

get_work_path

. ${workfolder}/../env/env.properties

. /etc/profile >/dev/null 2>&1
TMOUT=0

BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${MONITOR_HOME}/lib/"
CONF_DIR="${MONITOR_HOME}/conf/"
LOCAL_JAR=$(ls "${MONITOR_HOME}/lib/" | sed "s|^|${MONITOR_HOME}/lib/|" | tr '\n' ':')
JAVA_CP=$CLASSPATH:$LOCAL_JAR:${CONF_DIR}
JAVA_OPTS="-Dlog4j.configurationFile=${CONF_DIR}log4j2_cmd.xml -Dlog4j2.formatMsgNoLookups=true -Dbase.dir=${BASE_DIR}"
JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
CIPHER_ROOT="${COMMON_HOME}/cipher"

export MONITOR_ROOT=${BASE_DIR}
export ETCD_ROOT=${ETCD_HOME}
export OSS_ROOT=${BASE_DIR}
export CIPHER_ROOT=${CIPHER_ROOT}
echo -main query_cert_deadline | ${ARBITRATION_JAVA_HOME}/bin/java $JAVA_OPTS -cp $JAVA_CP $JAVA_MAIN

exit $?
