#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
set +x

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]; then
    echo "please login as arbiter, then excute the script again."
    exit 1
fi

function get_work_path() {
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}" | awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]; then
        dir=$(echo "${dir}" | sed 's/^.//')
        cur_path="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]; then
        cur_path="$(pwd)/${dir}"
    else
        cur_path="${dir}"
    fi
    return 0
}
get_work_path

. /etc/profile >/dev/null 2>&1
. ${cur_path}/../env/env.properties
TMOUT=0

BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${MONITOR_HOME}/lib/"
CONF_DIR="${MONITOR_HOME}/conf/"
JAVA_OPTS="${JAVA_OPTS} -Dbeetle.application.home.path=${CONF_DIR} -Dlog4j.configurationFile=${CONF_DIR}log4j2_cmd.xml -Dlog4j2.formatMsgNoLookups=true -Dbase.dir=${BASE_DIR}"
LOCAL_JAR=$(ls $LIB_DIR | sed "s|^|$LIB_DIR|" | tr '\n' ':')
JAVA_CP=${CLASSPATH}:${LOCAL_JAR}:${CONF_DIR}
JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
CIPHER_ROOT="${COMMON_HOME}/cipher"

export MONITOR_ROOT=${BASE_DIR}
export ETCD_ROOT=${ETCD_HOME}
export OSS_ROOT=${BASE_DIR}
export CIPHER_ROOT=${CIPHER_ROOT}
read -p "Please input password of ca certificate." -s -r passwd1

repeat_count=3

while [ ${repeat_count} -gt 0 ]; do
    read -p "Please input new password of server certificate." -s -r pwd_server1
    read -p "Please input password of server certificate again." -s -r pwd_server2
    if [ "${pwd_server1}" == "${pwd_server2}" ]; then
        break
    fi

    echo
    echo "The two inputs are inconsistent."
    repeat_count=$(echo "${repeat_count} - 1" | bc)

    if [ ${repeat_count} -le 0 ]; then
        echo "The number of retry times exceeds the maximum [3]. Exit"
        exit 1
    fi

    echo "Retry. Remaining times: ${repeat_count}"
    echo
done

echo "Please input new ca folder: "
read capath
echo -main iscertmgmt -mode replace -type ca -capath "${capath}" -capwd "${passwd1}" -pwd "${pwd_server1}" | ${ARBITRATION_JAVA_HOME}/bin/java $JAVA_OPTS -cp $JAVA_CP $JAVA_MAIN

# 控制替换后的CA相关证书权限
[ -f "${ETCD_HOME}/ca/ca.cer" ] && chmod 600 ${ETCD_HOME}/ca/ca.cer
[ -f "${ETCD_HOME}/ca/ca.csr" ] && chmod 600 ${ETCD_HOME}/ca/ca.csr
[ -f "${ETCD_HOME}/ca/ca_key.pem" ] && chmod 600 ${ETCD_HOME}/ca/ca_key.pem

exit $?
