#! /bin/bash
#
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#
set +x

function set_env() {
    get_work_path || return 1
    . ${curPath}/../env/env.properties
    TMOUT=0
}

function check_execute_user() {
    cur_user=$(id -un)
    if [ "${cur_user}" != "arbiter" ]; then
        echo "please login as arbiter, then execute the script again."
        return 1
    fi
}

function get_work_path() {
    dir=$(dirname "$0")
    is_point_start=$(echo "${dir}" | awk -F/ '{print $1}')
    if [ "${is_point_start}" == "." ]; then
        dir=$(echo "${dir}" | sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${is_point_start}" == ".." ]; then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}

function init_params() {
    MAIN_CMD=$1
    CMD_TARGET=$2
    if [ "${MAIN_CMD}" == "update_cipher" ]; then
        read -s -p "please input random password:" RANDOM_PASSWORD
    fi

    BASE_DIR="${MONITOR_HOME}"
    LIB_DIR="${MONITOR_HOME}/lib/"
    CONF_DIR="${MONITOR_HOME}/conf/"
    LOCAL_JAR=$(ls "${LIB_DIR}" | sed "s|^|${LIB_DIR}|" | tr '\n' ':')
    JAVA_CP=${CLASSPATH}:${LOCAL_JAR}:${CONF_DIR}
    JAVA_OPTS="-Dlog4j.configurationFile=${CONF_DIR}log4j2_cmd.xml -Dlog4j2.formatMsgNoLookups=true -Dbase.dir=${BASE_DIR}"
    JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
    CIPHER_ROOT="${COMMON_HOME}/cipher"
}

function execute_java() {
    export MONITOR_ROOT="${BASE_DIR}"
    export ETCD_ROOT="${ETCD_HOME}"
    export CIPHER_ROOT=${CIPHER_ROOT}

    java_params="-main ${MAIN_CMD}"
    if [ -n "${CMD_TARGET}" ]; then
        java_params="${java_params} -target ${CMD_TARGET}"
    fi
    if [ -n "${RANDOM_PASSWORD}" ]; then
        java_params="${java_params} -pwd ${RANDOM_PASSWORD}"
    fi
    echo ${java_params} | ${ARBITRATION_JAVA_HOME}/bin/java ${JAVA_OPTS} -cp ${JAVA_CP} ${JAVA_MAIN}
}

function main() {
    check_execute_user || return 1
    set_env || return 1
    init_params "$@" || return 1
    execute_java || return 1
}

main "$@"
