#!/bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: remote_modify_ha.sh
# Description: 调用远程OMP上的脚本刷新ha.properties
###########################################################

function get_work_path() {
    dir=$(dirname "$0")
    is_point_start=$(echo "${dir}" | awk -F/ '{print $1}')
    if [ "${is_point_start}" == "." ]; then
        dir=$(echo "${dir}" | sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${is_point_start}" == ".." ]; then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}

function arbitration_log() {
    level=$1
    info=$2
    echo "[$(date "+%Y-%m-%d %H:%M:%S")] [${level}] ${info}" >>${curPath}/modify_dr_ha.log
}

function get_params() {
    omp_ip_address=$1
    login_user_name=$2
    target_field=$3
    read -s -p "please input login password:" -r login_user_pwd
    read -s -p "please input ossadm password:" -r ossadm_user_pwd
    read -s -p "please input random password:" -r random_pwd

    # 转义特殊字符
    login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    random_pwd=$(echo ${random_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

# 登录OMP节点，执行OMP上预置的刷新ha.properties的脚本modify_ha.sh
function remote_exec() {
    arbitration_log INFO "execute modify ha: ${omp_ip_address} ${target_field}"
    ${EXPECT} <<ENF >/dev/null 2>&1
set timeout 30
spawn ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null ${login_user_name}@${omp_ip_address}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
        send "su - ossadm\r"
        expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send -- "${ossadm_user_pwd}\r"}
            "*ossadm@*" {send "\r"}
        }

        expect {
            "*ossadm@*" {
                send "bash /opt/oss/manager/apps/DRService/shscript/modify_ha.sh ${target_field}\r"
                expect {
                        "please input random password:" {send -- "${random_pwd}\r"}
                       }
                expect {
                    "*modify properties failed*" { exit 255 }
                    "*modify properties successfully*" { exit 100 }
                    }
                }
        }

        expect {
            "*ossadm@*" {send "exit\r"}
        }

    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

ENF

    expect_result=$?
    arbitration_log INFO "remote execute to [${omp_ip_address}] result: ${expect_result}"
    return $expect_result
}

function init_env() {
    get_work_path || return 1
    . ${curPath}/../env/env.properties
    EXPECT=expect
}

function main() {
    init_env || return -1

    # 获取参数
    get_params "$@" || return -1

    # 调用远程脚本修改
    for i in {1..2}; do
        if [ $i -gt 1 ]; then
            arbitration_log INFO "try remote exec ${i}."
        fi
        remote_exec
        if [ $? -eq 100 ]; then
            arbitration_log INFO "modify properties successfully."
            return 0
        fi
    done
    arbitration_log ERROR "modify properties failed."
    return 1
}

main "$@"
