#! /bin/bash
#
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#
set +x

function set_env() {
    get_work_path || return 1
    . ${curPath}/../env/env.properties
    TMOUT=0
}

function check_execute_user() {
    cur_user=$(id -un)
    if [ "${cur_user}" != "arbiter" ]; then
        echo "please login as arbiter, then execute the script again."
        return 1
    fi
}

function get_work_path() {
    dir=$(dirname "$0")
    is_point_start=$(echo "${dir}" | awk -F/ '{print $1}')
    if [ "${is_point_start}" == "." ]; then
        dir=$(echo "${dir}" | sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${is_point_start}" == ".." ]; then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}

function build_java_params() {
    JAVA_PARAMS="-main sync_dr_ha"
    if [ -n "${OMP_IP}" ]; then
        JAVA_PARAMS="${JAVA_PARAMS} -omp ${OMP_IP}"
    else
        echo "invalid param login user"
        return 1
    fi
    if [ -n "${LOGIN_USER}" ]; then
        JAVA_PARAMS="${JAVA_PARAMS} -login ${LOGIN_USER}"
    else
        echo "invalid param login user"
        return 1
    fi
    if [ -n "${LOGIN_PASSWORD}" ]; then
        JAVA_PARAMS="${JAVA_PARAMS} -pwd ${LOGIN_PASSWORD}"
    else
        echo "invalid param login password"
        return 1
    fi
    if [ -n "${OSSADM_PASSWORD}" ]; then
        JAVA_PARAMS="${JAVA_PARAMS} -ossadmPwd ${OSSADM_PASSWORD}"
    else
        echo "invalid param ossadm password"
        return 1
    fi
}

function init_params() {
    read -p "please input OMP IP:" OMP_IP
    read -p "please input login user:" LOGIN_USER
    read -s -p "please input login password:" LOGIN_PASSWORD
    echo ""
    read -s -p "please input ossadm password:" OSSADM_PASSWORD
    echo ""

    BASE_DIR="${MONITOR_HOME}"
    LIB_DIR="${MONITOR_HOME}/lib/"
    CONF_DIR="${MONITOR_HOME}/conf/"
    LOCAL_JAR=$(ls "${LIB_DIR}" | sed "s|^|${LIB_DIR}|" | tr '\n' ':')
    JAVA_CP=${CLASSPATH}:${LOCAL_JAR}:${CONF_DIR}
    JAVA_OPTS="-Dlog4j.configurationFile=${CONF_DIR}log4j2_cmd.xml -Dlog4j2.formatMsgNoLookups=true -Dbase.dir=${BASE_DIR}"
    JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
    CIPHER_ROOT="${COMMON_HOME}/cipher"

    build_java_params
}

function execute_java() {
    export MONITOR_ROOT="${BASE_DIR}"
    export ETCD_ROOT="${ETCD_HOME}"
    export CIPHER_ROOT=${CIPHER_ROOT}
    echo ${JAVA_PARAMS} | ${ARBITRATION_JAVA_HOME}/bin/java ${JAVA_OPTS} -cp ${JAVA_CP} ${JAVA_MAIN}
}

function main() {
    check_execute_user || return 1
    set_env || return 1
    init_params "$@" || return 1
    execute_java || return 1
    echo "synchronize DRService ha.properties success."
}

main "$@"
