#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
function get_work_path() {
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}" | awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]; then
        dir=$(echo "${dir}" | sed 's/^.//')
        cur_path="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]; then
        cur_path="$(pwd)/${dir}"
    else
        cur_path="${dir}"
    fi
    return 0
}
get_work_path

. ${cur_path}/../env/env.properties
ARBITRATION_WATCHDOG_LOG_FILE_PATH="${ARBITTRATION_WATCHDOG_LOG}/arbitration_watchdog.log"

. ${cur_path}/public.sh
env_ips=$(get_current_ips)

function check_ntp() {
    echo "[$(date "+%Y-%m-%d %H:%M:%S")] begin to check ntp service ..." >>$ARBITRATION_WATCHDOG_LOG_FILE_PATH
    local ntp_script="${cur_path}/common_ntp.sh"
    bash "${ntp_script}" -cmd ntp_status_track | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH 2>&1
    if [ $? -ne 0 ]; then
        echo "the ntp server can not connect." | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
        bash "${ntp_script}" -cmd start | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
    fi

    local using_server=$(bash "${ntp_script}" -cmd using_server)
    local ntp_date_result=$(ntpdate -q ${using_server})
    ntp_date_result=${ntp_date_result#*offset }
    local offset=${ntp_date_result%%.*}
    if [ ${offset} -gt 10 -o ${offset} -lt -10 ]; then
        echo "the ntp offset greater then 10s." | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
        local ntpip=$(bash "${ntp_script}" -cmd using_server)
        bash "${ntp_script}" -cmd stop

        sleep 1
        ntpdate ${using_server} >>$ARBITRATION_WATCHDOG_LOG_FILE_PATH 2>&1
        sleep 1

        bash "${ntp_script}" -cmd start
    fi

    return 0
}

function init_etcd() {
    check_ntp
}

function check_running() {
    mkdir -p "${cur_path}/Pid"
    touch ${cur_path}/Pid/$$
    sleep 1
    clear_invalid_pid
    local small_pid=$(ls ${cur_path}/Pid | sort -n | head -n 1)
    ps -ef | grep -wq "${small_pid}" || rm -f "${small_pid}"
    if [ "$$" -gt "${small_pid}" ];then
        echo "[$(date "+%Y-%m-%d %H:%M:%S")] arbitration_watchdog is already run! pid is ${small_pid}" | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
        rm -f "${cur_path}/Pid/$$"
        return 1
    fi
}

function clear_invalid_pid() {
    pid_list=$(ls "${ARBITRATION_HOME}/script/Pid/" 2>/dev/null)
    for pid in ${pid_list[@]}; do
        ps -fp "${pid}" >/dev/null || rm -f "${ARBITRATION_HOME}/script/Pid/${pid}"
        ps -fp "${pid}" | grep 'aamonitor_watch' >/dev/null || rm -f "${ARBITRATION_HOME}/script/Pid/${pid}"
    done
}

function main() {
    check_running || return 1
    is_aaetcd_started=$(ps -efwww | grep -w "Dbase.dir=${MONITOR_HOME}" | grep RaftServerMain | grep -v grep)
    is_aamonitor_started=$(ps -efwww | grep -w "Dbase.dir=${MONITOR_HOME}" | grep AAMonitor | grep -v grep)
    etcd_mode=$(cat ${MONITOR_HOME}/conf/aam.properties | grep "^etcd.mode" | cut -d "=" -f 2)
    aamonitor_mode=$(cat ${MONITOR_HOME}/conf/aam.properties | grep "^start.mode" | cut -d "=" -f 2)

    if [ "${is_aaetcd_started}" == "" ] && [ "${etcd_mode}" == "true" ]; then
        init_etcd && sudo -u arbiter bash ${ETCD_HOME}/script/service.sh restart >/dev/null 2>&1
        echo "[$(date "+%Y-%m-%d %H:%M:%S")] Can not find aaetcd, restart aaetcd" >>$ARBITRATION_WATCHDOG_LOG_FILE_PATH
    fi

    if [ "${is_aamonitor_started}" == "" ] && [ "${aamonitor_mode}" == "true" ]; then
        sleep 10
        sudo -u arbiter bash ${MONITOR_HOME}/script/service.sh restart >/dev/null 2>&1
        echo "[$(date "+%Y-%m-%d %H:%M:%S")] Can not find aamonitor, restart aamonitor" >>$ARBITRATION_WATCHDOG_LOG_FILE_PATH
    fi
    rm -f "${cur_path}/Pid/$$"
}

main
