#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./env.properties
function check_package() {
    ls /opt/arbitration_file/arbitration-common*.zip >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "No arbitration-common.zip found. Skip."
        return 1
    fi
    ls /opt/arbitration_file/arbitration-monitor*.zip >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "No arbitration-monitor.zip found. Skip."
        return 1
    fi
    ls /opt/arbitration_file/arbitration-etcd*.zip >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "No arbitration-etcd.zip found. Skip."
        return 1
    fi
}

function clear_arbitration_path() {
    arbitration_paths=(${ETCD_HOME} ${MONITOR_HOME} ${COMMON_HOME} ${ARBITRATION_HOME})
    for path in ${arbitration_paths[@]}; do
        if [ -e ${path} ]; then
            rm -rf ${path}
            echo "clear arbitration path: ${path}"
        fi
    done
}

# 生成3层加密秘钥
function generate_cipher_keys() {
    local cipher_path="${MONITOR_HOME}"/conf/cipher
    if [ -f "${cipher_path}/data_word" ]; then
        return 0
    fi

    sudo -u arbiter bash "${MONITOR_HOME}/script/arb_cipher_keys.sh" generate_cipher_keys || return 1
    chmod 600 ${MONITOR_HOME}/conf/cipher/*
}

function restore_or_generate_cipher_keys() {
    # 尝试从备份中恢复密钥，失败不return 1, 继续生成新密钥
    if [ -d /opt/backupArb ]; then
        cd /opt/arbitration_file && bash backup_restore_certificate.sh restore_ck
    fi

    generate_cipher_keys || return 1
}

# 初始化
function init() {
    clear_arbitration_path || return 0
    check_package || return 0
    # 兼容老版本卸载
    if [ "${INDEX}" = "0" ]; then
        rpm -qa 2>/dev/null | grep arbitration | xargs -r rpm -e 2>/dev/null
    fi
    modify_arbitration_file
    unzip_common || return 1
    unzip_etcd || return 1
    unzip_monitor || return 1
    save_install_home || return 1
    mkdir -p ${ARBITRATION_LOG}
    chown -R arbiter: /var/log/arbitration
    chmod 750 /var/log/arbitration
    chmod 750 ${ARBITRATION_LOG}

    restore_or_generate_cipher_keys || return 1
}

function modify_arbitration_file() {
    chmod 400 /opt/arbitration_file/*.pyc >/dev/null 2>&1
    chmod 400 /opt/arbitration_file/*.zip >/dev/null 2>&1
}

function unzip_etcd() {
    rm -rf ${ETCD_HOME}
    unzip /opt/arbitration_file/arbitration-etcd*.zip -d ${ETCD_HOME} >/dev/null
    cd ${ETCD_HOME}
    chmod 750 .
    chmod 750 *
    chmod 600 conf/*
    chmod 500 script/*
    chown arbiter: ${ETCD_HOME} -R
    rm -rf ${ETCD_LOG}
    mkdir -p ${ETCD_LOG}
    chmod 750 ${ETCD_LOG_BASE}
    chmod 750 ${ETCD_LOG}
    chown arbiter: ${ETCD_LOG_BASE} -R

    if [ ! -d "ca" ]; then
        mkdir ca
        chown arbiter: ca
        chmod 700 ca
    fi
}

function unzip_monitor() {
    rm -rf ${MONITOR_HOME}
    unzip /opt/arbitration_file/arbitration-monitor*.zip -d ${MONITOR_HOME} >/dev/null
    cd ${MONITOR_HOME}
    chmod 750 .
    chmod 750 conf
    chmod 600 conf/*
    chmod 700 conf/cipher
    chmod 600 conf/cipher/*
    chmod 750 lib
    chmod 400 lib/*
    chmod 750 script
    chmod 500 script/*
    chmod 400 script/*.pyc
    chown arbiter: ${MONITOR_HOME} -R
    rm -rf ${MONITOR_LOG}
    mkdir -p ${MONITOR_LOG}
    chmod 750 ${MONITOR_LOG_BASE}
    chmod 750 ${MONITOR_LOG}
    chown arbiter: ${MONITOR_LOG_BASE} -R
}

function unzip_common() {
    rm -rf ${COMMON_HOME}
    unzip /opt/arbitration_file/arbitration-common*.zip -d ${COMMON_HOME} >/dev/null
    cd ${COMMON_HOME}
    chmod 750 .
    chmod 750 conf
    chmod 750 foss
    chmod 750 script
    chmod 700 cipher
    chmod 600 cipher/*
    chmod 600 conf/*
    chmod 500 script/*
    chmod 640 conf/arbitration-common-sysctl.conf
    touch /etc/rc.d/rc.local
    chmod u+x /etc/rc.d/rc.local
    [ -e ${COMMON_HOME}/script/setup.sh ] && ${COMMON_HOME}/script/setup.sh
    chown arbiter: ${COMMON_HOME} -R
}

# 保存安装目录
function save_install_home() {
    write_properties ${ETCD_HOME}/env
    write_properties ${MONITOR_HOME}/env
    write_properties ${COMMON_HOME}/env
}

# 写入配置文件
function write_properties() {
    path=$1
    rm -f ${path}/env.properties
    mkdir -p ${path}
    cp -f /opt/arbitration_file/env.properties ${path}/env.properties

    chown arbiter: ${path} -R
    chmod 750 ${path}
    chmod 640 ${path}/env.properties
}

function main() {
    init "$@" || return 1
}

main "$@"
if [ $? -ne 0 ]; then
    echo "arbitration_install failed" >&2
    exit 1
fi
