#!/bin/bash 
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: arbitration_install.sh
# Description: 仲裁安装脚本
###########################################################

CUR_PATH=$(cd $(dirname $0);pwd)
function init_log() {
    local current_path=$(echo $(cd $(dirname "$0"); pwd))
    LOG_PATH="/var/log/arbitration_install/install_frame"
    if [ -d "${LOG_PATH}" -a "${TYPE}" != "install_check" -a $(is_retry) -ne 0 ]; then
        # 日志存在则打包备份
        local time=$(date '+%Y-%m-%d_%H-%M')
        cd "${LOG_PATH}"
        mkdir -p "${LOG_PATH}/log_backup"
        tar --warning=no-file-changed -czf install_frams_${time}.tar.gz *.log >/dev/null 2>&1
        rm -f *.log >/dev/null 2>&1
        mv install_frams_${time}.tar.gz "${LOG_PATH}/log_backup"
        cd "${current_path}"
        clear_log "${LOG_PATH}/log_backup"
        chmod 440 ${LOG_PATH}/log_backup/*
    fi
    mkdir -p "${LOG_PATH}"
    LOG_FILE="${LOG_PATH}/arbitration_install_frame.log"
}

function is_retry() {
    local ret=1
    if [ "${TYPE}" == "commissioning" ]; then
        rm -f "/opt/arbitration_file/arbitration_install_frame/arbitration_install_result.json"
    fi
    if [ -f "/opt/arbitration_file/arbitration_install_frame/arbitration_install_result.json" ]; then
        ret=0
    fi
    echo ${ret}
}

# 日志绕接清理
function clear_log() {
    local log_path=$1
    local need_clear_num=$(echo $(($(ls ${log_path} | grep ".tar.gz" | wc -l) - 20)))
    find ${log_path} -name "*.log.gz" | sort | head -n ${need_clear_num} | xargs rm -f > /dev/null 2>&1
}

# 第一步解析参数
function parse_properties_param() {
    while read line || [ -n "${line}" ]
    do
        echo ${line} | grep -q "=" 
        if [ $? -ne 0 ]
        then
            continue
        fi
        if [ -z "${KVS_PARAM}" ]; then
            KVS_PARAM=$(echo ${line})
        else
            KVS_PARAM="${KVS_PARAM},${line}"
        fi
    done < /opt/arbitration_file/arbitration_install_frame/config/arbitration_install.properties
}

# 第二步接受密码参数
function read_pwd_param() {
    echo "es_input: node_1_pwd"
    read -rs NODE_1_PWD
    echo "es_input: node_2_pwd"
    read -rs NODE_2_PWD
    echo "es_input: node_3_pwd"
    read -rs NODE_3_PWD
    echo "es_input: node_4_pwd"
    read -rs NODE_4_PWD
    echo "es_input: node_5_pwd"
    read -rs NODE_5_PWD
    echo "es_input: node_1_root_pwd"
    read -rs NODE_1_ROOT_PWD
    echo "es_input: node_2_root_pwd"
    read -rs NODE_2_ROOT_PWD
    echo "es_input: node_3_root_pwd"
    read -rs NODE_3_ROOT_PWD
    echo "es_input: node_4_root_pwd"
    read -rs NODE_4_ROOT_PWD
    echo "es_input: node_5_root_pwd"
    read -rs NODE_5_ROOT_PWD
    echo "es_input: master_omp_node_pwd"
    read -rs MASTER_OMP_NODE_PWD
    echo "es_input: master_omp_node_ossadm_pwd"
    read -rs MASTER_OMP_NODE_OSSADM_PWD
    echo "es_input: slave_omp_node_pwd"
    read -rs SLAVE_OMP_NODE_PWD
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -rs SLAVE_OMP_NODE_OSSADM_PWD
    echo "es_input: os_pwd_sopuser"
    read -rs OS_PWD_SOPUSER
    echo "es_input: product_pwd_ossadm"
    read -rs PRODUCT_PWD_OSSADM
    if [ "${OS_PWD_SOPUSER}" = "isEmpty" -o "${OS_PWD_SOPUSER}" = "" ]; then
        OS_PWD_SOPUSER=${NODE_5_PWD}
    fi
    INTERACT_PARAM="node_1_pwd,node_2_pwd,node_3_pwd,node_4_pwd,node_5_pwd,node_1_root_pwd,node_2_root_pwd,node_3_root_pwd,node_4_root_pwd,node_5_root_pwd,master_omp_node_pwd,master_omp_node_ossadm_pwd,slave_omp_node_pwd,slave_omp_node_ossadm_pwd,os_pwd_sopuser,product_pwd_ossadm"
}
# 第三步解压本地python
function unzip_python() {
    local python_zip=$(ls /opt/arbitration_file | grep EnvPython | grep "\.zip$")
    if [ ! -f "/opt/arbitration_file/${python_zip}" ]; then
        echo "can not found python package." | tee -a "${LOG_FILE}"
        return 1
    fi
    ARBITRATION_TEMP_PATH=/opt/arbitration_file/arbitration_temp
    bash /opt/arbitration_file/get_arbitration_python.sh ${ARBITRATION_TEMP_PATH} > /dev/null
    TEMP_ARBITRATION_PYTHON_HOME=${ARBITRATION_TEMP_PATH}/arbitration_python/bin/python
}

# 第四步调用执行框架
function start_execute() {
    ${TEMP_ARBITRATION_PYTHON_HOME} "${CUR_PATH}/arbitration_install.pyc" "${INTERACT_PARAM}" "${KVS_PARAM}" "${CONFIG_FILE}" <<EOF
${NODE_1_PWD}
${NODE_2_PWD}
${NODE_3_PWD}
${NODE_4_PWD}
${NODE_5_PWD}
${NODE_1_ROOT_PWD}
${NODE_2_ROOT_PWD}
${NODE_3_ROOT_PWD}
${NODE_4_ROOT_PWD}
${NODE_5_ROOT_PWD}
${MASTER_OMP_NODE_PWD}
${MASTER_OMP_NODE_OSSADM_PWD}
${SLAVE_OMP_NODE_PWD}
${SLAVE_OMP_NODE_OSSADM_PWD}
${OS_PWD_SOPUSER}
${PRODUCT_PWD_OSSADM}
EOF
}

function pre_install() {
    if [ "${TYPE}" != "install" ]; then
        return
    fi
    local result_file="/opt/arbitration_file/arbitration_install_frame/arbitration_install_result.json"
    local install_type=$(echo $(cat /opt/arbitration_file/arbitration_install_frame/config/arbitration_install.properties | grep install_type | awk -F"=" '{print $2}'))
    if [ "${install_type}" == "full_install" -a ! -f "${result_file}" ]; then
        rm -rf /opt/arbitration-monitor* /opt/arbitration-etcd* /opt/arbitration-common* /opt/arbitration /tmp/hsperfdata_arbiter /tmp/_wcc_file_locker_
        local tmp_path=$(pwd)
        cd /opt
        ls /opt | grep arbitration_ | grep -v arbitration_file | xargs rm -rf
        cd "${tmp_path}"
        sed -i '/aamonitor_watchdog/d' /etc/crontab
    fi
}

function main() {
    TYPE=$1
    init_log
    echo "start to ${TYPE} the arbitration." | tee -a "${LOG_FILE}"
    KVS_PARAM=""
    case ${TYPE} in
    "install")
        CONFIG_FILE="${CUR_PATH}/config/install_action.json"
        ;;
    "one_click_install")
        CONFIG_FILE="${CUR_PATH}/config/one_click_install_action.json"
        ;;
    "upgrade")
        CONFIG_FILE="${CUR_PATH}/config/upgrade_action.json"
        ;;
    "commissioning")
        CONFIG_FILE="${CUR_PATH}/config/commissioning_action.json"
        ;;
    "install_check")
        CONFIG_FILE="${CUR_PATH}/config/install_check_action.json"
        ;;
    "one_click_install_check")
        CONFIG_FILE="${CUR_PATH}/config/one_click_install_check_action.json"
        ;;
    "upgrade_backup")
        CONFIG_FILE="${CUR_PATH}/config/upgrade_backup_action.json"
        ;;
    "rollback")
        CONFIG_FILE="${CUR_PATH}/config/rollback_action.json"
        ;;
    "rollback_backup")
        CONFIG_FILE="${CUR_PATH}/config/rollback_backup_action.json"
        ;;
    esac
    if [ "${CONFIG_FILE}" == "" ]; then
        echo "${TYPE}" "The type of arbitration is error,type is: ${TYPE}." | tee -a "${LOG_FILE}"
        return 1
    fi
    parse_properties_param
    read_pwd_param
    unzip_python || return 1
    pre_install
    start_execute || return 1
    echo "success to ${TYPE} the arbitration." | tee -a "${LOG_FILE}"
}

function create_check_result_file() {
    local result_code=$1
    local script_name=$2
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -f /opt/arbitration_file/${script_name}
   " >"/opt/arbitration_file/${script_name}"

    chmod 500 "/opt/arbitration_file/${script_name}"
}

main "$@"
if [ $? -eq 0 ]; then
    $(create_check_result_file 100 arbitration_install_check_result.sh)
else
    $(create_check_result_file 255 arbitration_install_check_result.sh)
fi
exit $?