#!/bin/bash 
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: ssh_util.sh
# Description: 仲裁命令执行脚本，用于下发命令给本端或远程
###########################################################

export LC_ALL="en_US.UTF-8"
export LANG="en_US.UTF-8"

function init_log() {
    local current_path=$(echo $(cd "$(dirname "$0")"; pwd))
    LOG_PATH="/var/log/arbitration_install/install_frame"
    mkdir -p "${LOG_PATH}"
    LOG_FILE="${LOG_PATH}/${HOST}-install.log"
}

#脚本参数定义
function init_param() {
    local OPTIND arg
    while getopts "h:u:p:r:c:t:i:w:n:" arg
    do
        case ${arg} in
            h)
                HOST=${OPTARG}
                ;;
            u)
                USER=${OPTARG}
                ;;
            p)
                PORT=${OPTARG}
                ;;
            r)
                SU_USER=${OPTARG}
                ;;
            c)
                CMD=${OPTARG}
                ;;
            t)
                TIMEOUT=${OPTARG}
                ;;
            i)
                INTERACT_PARAM=${OPTARG}
                ;;
            w)
                WORK_PATH=${OPTARG}
                ;;
            n)
                NUMS=${OPTARG}
                ;;
            *)
                exit 1
            ;;
        esac
    done
    
    if [ -z "${HOST}" ]; then
        echo "no host input"
        exit 1
    fi
    
    read -sr PASSWD
    PASSWD=$(echo "${PASSWD}" | base64 -d)
    PASSWD=$(echo ${PASSWD} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    if [ "${SU_USER}" != "" ]; then
        read -sr SU_PASSWD
        SU_PASSWD=$(echo "${SU_PASSWD}" | base64 -d)
        SU_PASSWD=$(echo ${SU_PASSWD} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    fi
    local index=0
    INTERACT_VALUE_ARRAY=()
    while ((${index} < ${NUMS}))
    do
        read -sr value
        if [ -z "${value}" ]; then
            value="isEmpty"
        else
            value=$(echo "${value}" | base64 -d)
        fi
        value=$(echo ${value} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g' | sed 's/ /\\ /g')
        INTERACT_VALUE_ARRAY[${index}]=${value}
        ((index++))
        value=
    done
    if [ "${TIMEOUT}" == "" ]; then
        TIMEOUT=30
    fi
}

# 远程执行
function execute_cmd_remote() {
    echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S') INFO ${HOST}: execute cd ${WORK_PATH}; ${CMD} user is ${USER}" >> "${LOG_FILE}"
    local expect_output=$(expect << ENF 2>${LOG_PATH}/error_output.log
        set timeout ${TIMEOUT}
        spawn ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -p ${PORT} ${USER}@${HOST}
        expect {
            "*No route to host*" { send_user "RESULT=247\r"; exit;}
            "*Name or service not known*" { send_user "RESULT=247\r"; exit;}
            "*Connection refused*" { send_user "RESULT=247\r"; exit;}
            "*Permission denied*" { send_user "RESULT=247\r"; exit;}
            "*assword:*" { send -- "${PASSWD}\r";exp_continue}
            "*\$*" {send "\r"}
            "*${USER}*" {send "\r"}
            "*\#*" {send "\r"}
            timeout { send_user "RESULT=248\r"; exit;  }
        }

        if { "${SU_USER}" != "" } {
            expect {
                "*${USER}*" {send "su - ${SU_USER} \r"}
                "*\$*" {send "su - ${SU_USER} \r"}
                timeout { send_user "RESULT=248\r"; exit;  }
            }

            expect {
                "*assword:" {send -- "${SU_PASSWD}\r";exp_continue}
                "*\#*" {send "\r"}
                "*Permission denied*" { send_user "RESULT=247\r"; exit;  }
                "*Authentication failure*" { send_user "RESULT=247\r"; exit;  }
                timeout { send_user "RESULT=248\r"; exit;  }
            }
        }
        expect "*\#*"
        send "echo '______execute_start______';cd ${WORK_PATH};${CMD};echo execute_result=\$?;echo x'______execute_end______'; \r"
        foreach value {${INTERACT_VALUE_ARRAY[@]}} {
            expect {
                "es_input:*" {
                    send -- "\$value\r"
                }
                "x______execute_end______" {exit}
            }
        }
        expect {
            "x______execute_end______" {exit}
            timeout { send_user "RESULT=249\r"; exit;  }
        }
        expect eof
ENF
)

    local start_line=$(echo "${expect_output}" | grep -n "^______execute_start______" | awk -F':' '{print $1}')
    local end_line=$(echo "${expect_output}" | grep -n "______execute_end______" | tail -1 | awk -F':' '{print $1}')
    echo "${expect_output}" | sed -n "${start_line},${end_line}p" 2>/dev/null | sed '/______execute_start______/d' 2>/dev/null | sed 's/execute_result=.*//g' 2>/dev/null | sed '/______execute_end______/d' 2>/dev/null | sed '/^$/d' 2>/dev/null | tee -a ${LOG_FILE}
    cat ${LOG_PATH}/error_output.log >&2
    echo "${expect_output}" | egrep "RESULT=247|RESULT=248|RESULT=249|RESULT=255"  >> "${LOG_FILE}"
    if [ $? -eq 0 ]; then
        echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S') end execute ${CMD}. RESULT not 100." >> "${LOG_FILE}"
        echo "RESULT=255" >&2
        return 1
    fi
    local ret_code=$(echo "${expect_output}" |grep -v "execute_end" | grep "execute_result=" | awk -F"=" '{print $NF}' | tr -cd "[0-9]")
    return ${ret_code}
}

function execute_cmd() {
    echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S') INFO ${HOST}: start to execute cmd: cd ${WORK_PATH};${CMD} success" | tee -a "${LOG_FILE}"
    local ret=0
    execute_cmd_remote || ret=$?
    local error_output=$(cat ${LOG_PATH}/error_output.log)
    if [ ${ret} -ne 0 -a "${INTERACT_PARAM}" == "yes" ] || [ -n "${error_output}" -a "${INTERACT_PARAM}" != "yes" ]; then
        echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S') ERROR ${HOST}: execute cmd: cd ${WORK_PATH};${CMD} failed" | tee -a "${LOG_FILE}"
    else
        echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S') INFO ${HOST}: execute cmd: cd ${WORK_PATH};${CMD} success" | tee -a "${LOG_FILE}"
    fi
    echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S') end execute ${CMD}. ret_code is ${ret}" >> "${LOG_FILE}"
    return ${ret}
}
function main() {
    init_param "$@"
    init_log
    execute_cmd || return $?
}
main "$@"
exit $?