#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh

function create_check_file() {
    result_code=$1
    create_check_result_file ${result_code} "check_backup_restore_drconfig.sh"
}

# 登录OMP节点，执行OMP上执行相关脚本
function remote_exec() {
    ${EXPECT} <<ENF >/dev/null 2>&1
set timeout 30
spawn ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null ${login_user_name}@${omp_ip_address}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
                            send "su - ossadm\r"
                            expect {
                                "*yes/no*" {send "yes\r";exp_continue}
                                "*assword:" {send -- "${ossadm_user_pwd}\r"}
                            }

                            expect {
                                "*ossadm@*" {
                                    send "bash /opt/oss/manager/apps/DRService/shscript/upgrade_modify_ha.sh ${operation_type} ${backup_dir}\r"

                                    expect {
                                        "*modify ha failed*" { exit 255 }
                                        "*modify ha successfully*" { exit 100 }
                                    }
                                }
                            }

                            expect {
                                "*ossadm@*" {send "exit\r"}
                            }

    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]
ENF
    return $?
}

# 本地OMP节点，执行OMP上执行相关脚本
function local_exec() {
    ${EXPECT} <<ENF >/dev/null 2>&1
set timeout 30
spawn su - ossadm
expect {
    "*ossadm@*" {
        send "bash /opt/oss/manager/apps/DRService/shscript/upgrade_modify_ha.sh ${operation_type} ${backup_dir}\r"
        expect {
            "*modify ha failed*" { exit 255 }
            "*modify ha successfully*" { exit 100 }
        }
    }
}
expect {
    "*ossadm@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]
ENF
    return $?
}

function omp_exec() {
    ip addr | grep -w ${omp_ip_address} >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        arbitration_log INFO "BACKUP_RESTORE_CONFIG" "omp exec on local."
        local_exec
    else
        arbitration_log INFO "BACKUP_RESTORE_CONFIG" "omp exec on remote."
        remote_exec
    fi
    result=$?
    if [ ${result} -ne 100 ]; then
        arbitration_log ERROR "BACKUP_RESTORE_CONFIG" "${operation_type} ha config failed."
        return 255
    else
        arbitration_log INFO "BACKUP_RESTORE_CONFIG" "${operation_type} ha config successfully."
    fi
    return 0
}

function init() {
    read -p "es_input: master_omp_node_uname" -r master_login_user_name
    read -p "es_input: master_omp_node_pwd" -s -r master_login_user_pwd
    read -p "es_input: master_omp_node_ossadm_pwd" -s -r master_ossadm_user_pwd
    read -p "es_input: node_1_root_pwd" -s -r master_commonservice_root_pwd

    read -p "es_input: slave_omp_node_uname" -r slave_login_user_name
    read -p "es_input: slave_omp_node_pwd" -s -r slave_login_user_pwd
    read -p "es_input: slave_omp_node_ossadm_pwd" -s -r slave_ossadm_user_pwd
    read -p "es_input: node_3_root_pwd" -s -r slave_commonservice_root_pwd

    if [ "${site_role}" = "-master" ]; then
        login_user_name=${master_login_user_name}
        login_user_pwd=${master_login_user_pwd}
        ossadm_user_pwd=${master_ossadm_user_pwd}
        commonservice_root_pwd=${master_commonservice_root_pwd}
    else
        login_user_name=${slave_login_user_name}
        login_user_pwd=${slave_login_user_pwd}
        ossadm_user_pwd=${slave_ossadm_user_pwd}
        commonservice_root_pwd=${slave_commonservice_root_pwd}
    fi

    login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    commonservice_root_pwd=$(echo ${commonservice_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

function get_omp_maintaince_ip() {
    arbitration_log INFO "BACKUP_RESTORE_CONFIG" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(get_first_omp_ip)
    arbitration_log INFO "BACKUP_RESTORE_CONFIG" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

###################################################################
#
#
#    安装或升级仲裁软件中临时解压一个python路径
#
#
###################################################################
function unzip_temp_python() {
    ARBITRATION_TEMP_PATH=/opt/arbitration_file/arbitration_temp
    bash /opt/arbitration_file/get_arbitration_python.sh ${ARBITRATION_TEMP_PATH} >/dev/null
    TEMP_ARBITRATION_PYTHON_HOME=${ARBITRATION_TEMP_PATH}/arbitration_python/bin/python
}

function main() {
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "start to run backup or restore the dr config"
    unzip_temp_python
    rm -f /opt/arbitration_file/check_backup_restore_drconfig.sh

    site_role=$1
    omp_ip_address=$2
    local_ip_address=$3
    operation_type=$4
    backup_dir=$5
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "the operation type is ${operation_type}"

    # 根据用户输入的omp节点IP获取maintaince IP
    omp_ip_address=$(get_omp_maintaince_ip)
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "Get the OMP maintenance IP address is ${omp_ip_address}"

    EXPECT=expect
    init
    for i in {1..3}; do
        omp_exec
        omp_exec_result=$?
        if [ ${omp_exec_result} -eq 0 ]; then
            break
        fi
        arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "retry to modify remote ha properties"
        sleep 1
    done

    if [ ${omp_exec_result} -eq 0 ]; then
        $(create_check_file 100)
        [ -d ${ARBITRATION_TEMP_PATH} ] && rm -rf ${ARBITRATION_TEMP_PATH}
        return 0
    else
        $(create_check_file 255)
        return 1
    fi
}

main $@
