#!/bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: check_arbitration_omp.sh
# Description: 检查用户Easysuite界面输入的omp节点信息是否正确
###########################################################
function get_params() {
    SITE_ROLE=$1
    OMP_IP=$2
    OMP_UNAME=$3
    COMMON_SERVICE_IPS=$4
    common_service_list=($(echo ${COMMON_SERVICE_IPS} | tr ',' ' '))
    COMMON_SERVICE_COUNT=${#common_service_list[@]}
    check_param

    read -p "es_input: master_omp_node_pwd" -s -r master_omp_node_pwd
    read -p "es_input: master_omp_node_ossadm_pwd" -s -r master_omp_node_ossadm_pwd

    read -p "es_input: slave_omp_node_pwd" -s -r slave_omp_node_pwd
    read -p "es_input: slave_omp_node_ossadm_pwd" -s -r slave_omp_node_ossadm_pwd

    if [ "${SITE_ROLE}" = "-master" ]; then
        omp_node_pwd=${master_omp_node_pwd}
        omp_node_ossadm_pwd=${master_omp_node_ossadm_pwd}
    else
        omp_node_pwd=${slave_omp_node_pwd}
        omp_node_ossadm_pwd=${slave_omp_node_ossadm_pwd}
    fi

    # 特殊字符转义
    omp_node_pwd=$(echo ${omp_node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    omp_node_ossadm_pwd=$(echo ${omp_node_ossadm_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

function check_param() {
    local dr_count=$(cat /opt/oss/manager/var/agent/managerip.conf | grep "^managerip" | awk -F= '{print $NF}' | sed 's/,/\n/g' | wc -l)
    echo "Enter the check dr_count: ${dr_count},common_service_count:${COMMON_SERVICE_COUNT}."
    if [[ "${COMMON_SERVICE_COUNT}" -eq 0 ]]; then
        echo "no need to check node count"
        return
    fi

    if [[ "${dr_count}" -eq 2 && "${COMMON_SERVICE_COUNT}" -ne 5 ]]; then
        echo "[ERROR] Distributed scenario please install 5 node arbiter"
        exit 1
    fi

    if [[ "${dr_count}" -eq 1 && "${COMMON_SERVICE_COUNT}" -ne 3 ]]; then
        echo "[ERROR] Single tube please install 3 node arbiter"
        exit 1
    fi
    echo "Pass the node check"
}

function get_omp_maintenance_ip() {
    arbitration_log INFO "CHECK_OMP" "Start to get the OMP maintenance IP address."
    local omp_maintenance_ip=$(get_first_omp_ip)
    arbitration_log INFO "CHECK_OMP" "Success to get the OMP maintenance IP address is ${omp_maintenance_ip}."
    echo ${omp_maintenance_ip}
}

function check_login() {
    expect <<ENF >/dev/null 2>&1
set timeout 30
spawn ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null ${OMP_UNAME}@${OMP_IP}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${omp_node_pwd}\r"}
}

expect {
    "*No route to host*" { exit 101 }
    "*Permission denied*" { exit 102 }
    "*please try again*" { exit 102}
    "*${OMP_UNAME}@*" {
        send "su - ossadm\r"
        expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send -- "${omp_node_ossadm_pwd}\r"}
            "*ossadm@*" {send "\r"}
        }

        expect {
            "*ossadm@*" { exit 100 }
            "*Permission denied*" { exit 103 }
            "*Authentication fail*" { exit 103 }
        }

        expect {
            "*${OMP_UNAME}@*" {send "exit\r"}
        }
    }
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

ENF
    check_login_result=$?
    if [ -z ${check_login_result} ]; then
        echo "[ERROR] The user name or password of the ${SITE_ROLE#*-} OMP node cannot be used to log in."
        arbitration_log ERROR "CHECK_OMP_INFO" "The user name or password of the ${SITE_ROLE#*-} OMP node cannot be used to log in."
        return 1
    fi
    if [ ${check_login_result} -ne 100 ]; then
        if [ ${check_login_result} -eq 101 ]; then
            echo "[ERROR] The connection to the ${SITE_ROLE#*-} OMP IP address is rejected."
            arbitration_log ERROR "CHECK_OMP_INFO" "The connection to the ${SITE_ROLE#*-} OMP IP address is rejected."
            return 1
        elif [ ${check_login_result} -eq 102 ]; then
            echo "[ERROR] The user name or password of the ${SITE_ROLE#*-} OMP node is incorrect."
            arbitration_log ERROR "CHECK_OMP_INFO" "The user name or password of the ${SITE_ROLE#*-} OMP node is incorrect."
            return 1
        elif [ ${check_login_result} -eq 103 ]; then
            echo "[ERROR] Failure to log in to the ${SITE_ROLE#*-} OMP node as user ossadm."
            arbitration_log ERROR "CHECK_OMP_INFO" "Failure to log in to the ${SITE_ROLE#*-} OMP node as user ossadm."
            return 1
        else
            echo "[ERROR] Unknow error,please contact Huawei technical support."
            arbitration_log ERROR "CHECK_OMP_INFO" "Unknow error,please contact Huawei technical support."
            return 1
        fi
    fi
}

function main() {
    . ./arbitration_opertate_lib

    arbitration_log INFO "CHECK_OMP_INFO" "Start to check the OMP node information entered by the user."

    # 获取参数
    get_params "$@"

    # 获取当前站点的OMP IP地址
    # 如果获取到IP为空，两种可能：1 非容灾环境，没有DRService微服务 2 平台接口调用失败
    OMP_IP=$(get_omp_maintenance_ip)
    if [ -z "${OMP_IP}" ]; then
        echo "[ERROR] The DRService service does not exist in the environment. Check whether DR services are installed."
        arbitration_log ERROR "CHECK_OMP_INFO" "The DRService service does not exist in the environment. Check whether DR services are installed."
        return 1
    fi

    # 检查当前的用户名密码是否可以登录成功
    check_login || return 1

    arbitration_log INFO "CHECK_OMP_INFO" "Finish to check the OMP node information entered by the user."
}

main "$@"
if [ $? -eq 0 ]; then
    $(create_check_result_file 100 check_arbitration_omp_result.sh)
    exit 0
else
    $(create_check_result_file 255 check_arbitration_omp_result.sh)
    exit 1
fi
