#! /bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: check_arbitration_os.sh
# Description: 检查仲裁节点操作系统版本
###########################################################

########################################################
#
# Description: 获取SuSE操作系统版本
#
########################################################
function get_suse_version() {
    if [ "$(cat /proc/version | grep -i suse)" ];then
        local version=$(cat /etc/SuSE-release | grep ^VERSION | awk -F"=" '{print $2}' | xargs)
        local patch_level=$(cat /etc/SuSE-release | grep ^PATCHLEVEL | awk -F"=" '{print $2}' | xargs)
        echo "${version}.${patch_level}"
    fi
}

function check_os_version() {
    local os_version=$(get_suse_version)
    if [ "${os_version}" == "12.4" ]
    then
        echo "[ERROR] current os version:${os_version} is not support."
        return 1
    fi

    if [ -e /etc/kylin-release ]; then
        cat /etc/kylin-release | grep "Kylin" >/dev/null 2>&1
        if [ $? -eq 0 -a "$THIRD_MODE_SEK_SELECT" == "third_node_sek_select_yes" ]; then
            echo "[ERROR] Kylin OS does not support security hardening."
            return 1

        fi
    else
        if [ "$THIRD_MODE_SEK_SELECT" == "third_node_sek_select_no" ]; then
            echo "[ERROR] Security hardening must be performed on the current operating system."
            return 1
        fi
    fi
}

function main()
{
    . ./arbitration_opertate_lib
    . ./public.sh
    third_node_sek_select=$1
    check_os_version || return 1
}

main "$@"
if [ $? -eq 0 ];then
    create_check_result_file 100 "check_arbitration_os_result.sh"
else
    create_check_result_file 255 "check_arbitration_os_result.sh"
fi
exit $?
