#!/bin/bash
#
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
#
cd /opt/arbitration_file
. ./arbitration_opertate_lib
. ./public.sh

PUBLIC_IP=""
AB_INNER_IPS=""

###################################################################
#    初始化参数
###################################################################
function init() {
    master_and_slave_inner_card_ips=$1
    PUBLIC_IP=$2
    AB_INNER_IPS=($(echo ${master_and_slave_inner_card_ips} | tr ',' ' '))
    local node_size=${#AB_INNER_IPS[@]}
    get_root_params ${node_size}
}

function get_root_params() {
    local node_size=$1
    read -p "es_input: node_1_root_pwd" -s -r node_1_root_pwd
    read -p "es_input: node_2_root_pwd" -s -r node_2_root_pwd
    read -p "es_input: node_3_root_pwd" -s -r node_3_root_pwd
    read -p "es_input: node_4_root_pwd" -s -r node_4_root_pwd

    node_1_root_pwd=$(echo ${node_1_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    node_3_root_pwd=$(echo ${node_3_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

    node_root_pwd_list=(${node_1_root_pwd} ${node_3_root_pwd})

    if [ ${node_size} -eq 4 ]; then
        node_2_root_pwd=$(echo ${node_2_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
        node_4_root_pwd=$(echo ${node_4_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

        node_root_pwd_list=(${node_1_root_pwd} ${node_2_root_pwd} ${node_3_root_pwd} ${node_4_root_pwd})
    fi
}

###################################################################
# 校验仲裁节点间的连通性
###################################################################
function check_arbitration_connect() {
    for ((i=0; i<${#AB_INNER_IPS[@]}; i++));do
        local node_ip=${AB_INNER_IPS[i]}
        echo "${node_ip}" | grep ":" &>/dev/null
        if [[ $? -eq 0 ]]; then
            ping6 -c 2 ${node_ip} &>/dev/null
        else
            ping -c 2 ${node_ip} &>/dev/null
        fi
        if [[ $? -eq 0 ]]; then
            echo "Connect ${node_ip} is normal."
        else
            local check_connect_pyscript=/opt/arbitration_file/check_arbitration_connect.pyc
            ${TEMP_ARBITRATION_PYTHON_HOME} "${check_connect_pyscript}" "${node_ip}"
            if [ $? -eq 0 ]; then
                echo "check_arbitration_connect" "Connect ${node_ip} is normal."
            else
                echo "[ERROR] Connect ${node_ip} is abnormal."
                return 1
            fi
        fi
        check_arbitration_ssh_connect ${node_ip} ${node_root_pwd_list[i]} || return 1
    done
}

###################################################################
#       校验三方站点内部通信ip是否侦听22端口
###################################################################
function check_third_sshd_port()
{
    ifconfig | grep -w "${PUBLIC_IP}"> /dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "[ERROR] current does not exist third ip:${PUBLIC_IP}"
        return 0
    fi
    local listen_address_list=$(grep "^\s*ListenAddress" "/etc/ssh/sshd_config" | egrep -wv "0.0.0.0|::|::1|127.0.0.1" | awk '{print $2}')
    if [ -z "${listen_address_list}" ]; then
        return 0
    fi
    echo "${listen_address_list}" | grep -w "${PUBLIC_IP}" > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "[ERROR] Port 22 is not listening on ${PUBLIC_IP}."
        echo "[ERROR] Suggestion: Add ListenAddress ${PUBLIC_IP} to the /etc/ssh/sshd_config file and restart the sshd service."
        return 1
    fi
}

function check_arbitration_ssh_connect() {
    local host=$1
    local root_pwd=$2
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${node_ip} /d" /root/.ssh/known_hosts
    expect <<ENF > /dev/null 2>&1
set timeout 10
spawn ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -p 22 root@${host}
expect {
    "*No route to host*" { exit 1 }
    "*Name or service not known*" { exit 1 }
    "*Connection refused*" { exit 1 }
    "*Permission denied*" { exit 1 }
    "*assword:*" { send -- "${root_pwd}\r";exp_continue}
    "*Access denied*" { exit 1 }
    "*root*" { exit 0 }
    "*#" { exit 0 }
    timeout { exit 248 }
    }
expect timeout { exit 248 }
expect eof
ENF

    if [ $? -ne 0 ]; then
        echo "[ERROR] login ${host} failed."
        return 1
    fi
    echo "login ${host} success."
}

function main()
{
    init "$@"
    check_arbitration_connect || return 1
    check_third_sshd_port || return 1
}

main "$@"
if [ $? -eq 0 ]; then
    create_check_result_file 100 "check_arbitration_root_connect_result.sh"
else
    create_check_result_file 255 "check_arbitration_root_connect_result.sh"
fi
exit $?
