#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
###################################################################
#
#
#    初始化参数
#
#
###################################################################
function init() {
    master_node_ips=$1
    master_node_ips_list=($(echo $master_node_ips | tr ',' ' '))
    slave_node_ips=$2
    slave_node_ips_list=($(echo $slave_node_ips | tr ',' ' '))
    third_node_ip=$3

    all_access_ips=${master_node_ips}","${slave_node_ips}","${third_node_ip}
    all_access_ip_list=($(echo $all_access_ips | tr ',' ' '))

    old_master_nodes_ips=$(cat /opt/arbitration/conf/arbitration_conf.properties | grep master_nodes_inner_ips | awk -F = '{printf $2}')
    old_master_nodes_ips_list=($(echo $old_master_nodes_ips | tr ',' ' '))
    old_slave_nodes_ips=$(cat /opt/arbitration/conf/arbitration_conf.properties | grep slave_nodes_inner_ips | awk -F = '{printf $2}')
    old_slave_nodes_ips_list=($(echo $old_slave_nodes_ips | tr ',' ' '))
    old_third_node_ip=$(cat /opt/arbitration/conf/arbitration_conf.properties | grep third_node_inner_ip | awk -F = '{printf $2}')
    old_all_access_ips=${old_master_nodes_ips}","${old_slave_nodes_ips}","${old_third_node_ip}
    old_all_access_ip_list=($(echo $old_all_access_ips | tr ',' ' '))
}

###################################################################
#
#
#       检验节点上都安装过仲裁软件
#
#
###################################################################
function check_is_install_arbitration() {

    if [[ $(rpm -qa | grep arbitration) == "" ]]; then
        echo "this node doesn't install arbitration" >&2
        exit 1
    fi

}

###################################################################
#
#
#    校验主集群对应主集群，备集群对应备集群
#
#
###################################################################
function check_arbitration_node_isaccordance() {

    for ((j = 0; j < ${#master_node_ips_list[@]}; j++)); do
        local flag_master=0
        for ((k = 0; k < ${#old_master_nodes_ips_list[@]}; k++)); do

            if [[ ${master_node_ips_list[j]} == ${old_master_nodes_ips_list[k]} ]]; then
                flag_master=$(($flag_master + 1))
            fi

        done
        if [[ ${flag_master} != "1" ]]; then
            echo "${master_node_ips_list[j]} is not master arbitration" >&2
            exit 1
        fi
    done

    for ((j = 0; j < ${#slave_node_ips_list[@]}; j++)); do
        local flag_slave=0
        for ((k = 0; k < ${#old_slave_nodes_ips_list[@]}; k++)); do
            if [[ ${slave_node_ips_list[j]} == ${old_slave_nodes_ips_list[k]} ]]; then
                flag_slave=$(($flag_slave + 1))
            fi

        done
        if [[ ${flag_slave} != "1" ]]; then
            echo "${slave_node_ips_list[j]} is not slave arbitration" >&2
            exit 1
        fi

    done

    if [[ ${third_node_ip} != ${old_third_node_ip} ]]; then
        echo "This node is not third arbitration" >&2
        exit 1
    fi

}

###################################################################
#
#
#    校验原仲裁节点个数是否与升级节点数一致
#
#
###################################################################
function check_arbitration_node_number() {
    if [[ ${#all_access_ip_list[@]} != ${#old_all_access_ip_list[@]} ]]; then
        echo "the arbitration node nums are not consistent " >&2
        exit 1
    fi
}

###################################################################
#
#
#       检验有且仅有一个接入ip在此节点
#
#
###################################################################
function check_access_ip() {
    num=0
    for ((i = 0; i < ${#all_access_ip_list[@]}; i++)); do
        ifconfig | grep -wF "${all_access_ip_list[i]}" >/dev/null
        if [[ $? == "0" ]]; then
            num=$(($num + 1))

        fi
    done
    if [[ ${num} != "1" ]]; then
        echo "the access ip is not unique" >&2
        exit 1
    fi
}

###################################################################
#
#
#       检验新版本比原版本新
#
#
###################################################################

function check_before_arb_up() {
    #获取环境中仲裁软件版本
    local func_name="check_before_arb_up"

    local arb_version=$(cat /opt/arbitration-common/conf/version.ini | awk -F '-' '{print $3}')

    if [[ "${arb_version}" == "" ]]; then
        arbitration_log ERROR "${func_name}" "Can't get arbitration_version in this node,please check"
        echo "Can't get arbitration_version in this node,please check" >&2
        exit 1
    fi
    local arb_version_num=$(cat /opt/arbitration-common/conf/version.ini | awk -F '-' '{print $3}' | sed 's/ /./g')

    #新版本信息需要解压AAmonitor包获取

    if [[ -d /opt/arbitration_check_file ]]; then
        cd /opt/arbitration_check_file
    else
        cd /opt/arbitration_file
    fi
    local arb_new_version_num=$(ls | grep arbitration-common | awk -F '-' '{print $3,$4}' | awk -F 'x' '{print $1}' | sed 's/ /./g' | sed 's/.$//g')

    #新老版本版本号比较
    if version_compare ${arb_version_num} ${arb_new_version_num}; then
        echo "The upgrade version is not newer than installed" >&2
        exit 1
    fi

}

function version_compare() {
    test "$(echo "$@" | tr " " "\n" | sort -rV | head -n 1)" == "$1" >/dev/null 2>&1
}

function main() {
    check_is_install_arbitration
    init $@

    check_arbitration_node_number
    check_arbitration_node_isaccordance
    check_access_ip
    check_before_arb_up

}

main $@
