#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
## ##############################################################################
## #检查当前环境是否包含CommonService，并且仲裁安装在CommonService节点
## # ----------------------------------------------------------------
## # 参数为两个宏
## #
## ##############################################################################

NODE_JSON_FILES=""
NODE_DIR="/opt/oss/tmp/nodeInfo"

function get_work_path() {
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir | awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]; then
        dir=$(echo ${dir} | sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]; then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

function init_env() {
    . ./arbitration_opertate_lib >/dev/null 2>&1
    . ./env.properties >/dev/null 2>&1
    . ./public.sh >/dev/null 2>&1
}

function init_node_file() {
    delete_dir
    su - ossadm -c "mkdir -p ${NODE_DIR};chmod 700 ${NODE_DIR}" >/dev/null 2>&1
    su - ossadm -c "cd /opt/oss/manager/tools/resmgr;./queryproduct.sh -pn all -output ${NODE_DIR}" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "[ERROR] nodes_NCE.json not found, queryproduct failed." >&2
        return 1
    fi
    NODE_JSON_FILES=$(echo ${NODE_DIR}/nodes_*.json)
}

function unzip_python() {
    ARBITRATION_TEMP_PATH=/opt/arbitration_file/arbitration_temp
    bash /opt/arbitration_file/get_arbitration_python.sh ${ARBITRATION_TEMP_PATH} >/dev/null
    TEMP_ARBITRATION_PYTHON_HOME=${ARBITRATION_TEMP_PATH}/arbitration_python/bin/python
}

function delete_dir() {
    if [ -d ${workfolder}/common ]; then
        rm -rf ${workfolder}/common >/dev/null 2>&1
    fi
    if [ -d "${NODE_DIR}" ]; then
        rm -rf "${NODE_DIR}" >/dev/null 2>&1
    fi
}

function check_common_service() {
    local node_json_file=$1
    local node_type="Common_Service"
    grep "${node_type}" "${node_json_file}" >/dev/null
    if [ $? -ne 0 ]; then
        return 0
    fi

    # 设置查询节点名称脚本
    local script_path=$workfolder/get_nodeip.pyc
    if [ ! -f ${script_path} ]; then
        script_path=$workfolder/get_nodeip.py
    fi

    for service_host in $(ifconfig | grep -w inet | awk '{print $2}' | sed 's/addr://g'); do
        local param="${service_host} ${node_type}"
        ${TEMP_ARBITRATION_PYTHON_HOME} ${script_path} ${param} "${node_json_file}" >/dev/null 2>&1
        result=$?
        if [ ${result} -eq 0 ]; then
            return 0
        fi
    done
    return 1
}

function select_every_product() {
    for node_json_file in ${NODE_JSON_FILES}; do
        check_common_service ${node_json_file}
        if [ $? -eq 0 ]; then
            echo "The current node is Common_Service type"
            return 0
        fi
    done
    echo "[ERROR] The current node is not Common_Service type, please check your input" >&2
    return 1
}
function main() {
    get_work_path || return 1
    init_env || return 1
    init_node_file || return 1
    unzip_python || return 1
    select_every_product || return 1
    delete_dir
}

main
exit $?
