#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
function init() {
    CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
    source ${CURRENT_PATH}/../env/env.properties
    LOG_FILE="${ARBITTRATION_WATCHDOG_LOG}/arbitration_watchdog.log"
}

function check_sopuser_expires() {
    local offset_day=$(date -I -d '+30 day')
    local offset_num=$(date -d "${offset_day}" +%s)
    export LC_LAN=C
    local expire=$(chage -l sopuser 2>/dev/null | grep 'Password expires' | awk -F: '{print $2}')
    if echo "${expire}" | grep "never" >/dev/null 2>&1; then
        echo "okay"
        logger "The sopuser password never expires."
        return 0
    fi
    logger "Expiration time of the sopuser password is ${expire}."
    local expire_num=$(date -d "${expire}" +%s)
    local current=$(date -I)
    local current_num=$(date -d "${current}" +%s)
    logger "sopuser passwd check offset_time:${offset_num}, expire_time:${expire_num}, current_time:${current_num}."

    if [ "${current_num}" -gt "${expire_num}" ]; then
        echo "expired"
    elif [ "${offset_num}" -gt "${expire_num}" ]; then
        echo "warning"
    else
        echo "okay"
    fi
}

function logger() {
    local current_time=$(date "+%Y-%m-%d %H:%M:%S")
    echo "[$current_time] [check_etcd ${CHECK_IP}] $*" >>"${LOG_FILE}"
}

function main() {
    init "$@"
    check_sopuser_expires
}

main "$@"
