#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
ARBITRATION_SITE_SSH_CONFIG_START="#Arbitration site ssh config start"
ARBITRATION_SITE_SSH_CONFIG_END="#Arbitration site ssh config end"

function usage() {
    echo "Usage:"
    echo "    bash xx.sh {clear|refresh}"
}

##################################
#
# 修改前备份sshd_config文件
#
##################################
function backup() {
    cp -p /etc/ssh/sshd_config /etc/ssh/sshd_config_arbitration
}

##################################
#
# 修改完后替换sshd_config文件
#
##################################
function restore() {
    mv /etc/ssh/sshd_config_arbitration /etc/ssh/sshd_config
}

##################################
#
# 清理ssh监听配置
#
##################################
function clear_listenaddress() {
    sed -i '/^ListenAddress/d' /etc/ssh/sshd_config_arbitration
}

##################################
#
# 添加配置文件的头尾，后续的ListenAddress均在中间维护
#
##################################
function add_start_end() {
    grep "${ARBITRATION_SITE_SSH_CONFIG_START}" /etc/ssh/sshd_config_arbitration >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "${ARBITRATION_SITE_SSH_CONFIG_START}" >>/etc/ssh/sshd_config_arbitration
        echo "${ARBITRATION_SITE_SSH_CONFIG_END}" >>/etc/ssh/sshd_config_arbitration
    fi
}

##################################
#
# 增加ssh监听白名单
#
##################################
function add_listenaddress() {
    local local_ip_config=$(ifconfig)
    local ipv4s=$(ip addr | grep -w inet | awk '{print $2}' | awk -F'/' '{print $1}')
    for ipv4 in ${ipv4s[*]}; do
        echo "${local_ip_config}" | grep -w ${ipv4} > /dev/null
        if [ $? -ne 0 ];then
            continue
        fi
        sed -i "/${ARBITRATION_SITE_SSH_CONFIG_START}/aListenAddress ${ipv4}" /etc/ssh/sshd_config_arbitration
    done

    local ipv6s=$(ip addr | grep -w inet6 | awk '{print $2}' | awk -F'/' '{print $1}')
    for ipv6 in ${ipv6s[*]}; do
        echo "${local_ip_config}" | grep -w ${ipv6} > /dev/null
        if [ $? -ne 0 ];then
            continue
        fi
        sed -i "/${ARBITRATION_SITE_SSH_CONFIG_START}/aListenAddress ${ipv6}" /etc/ssh/sshd_config_arbitration
    done
}

##################################
#
# 重启sshd服务+
#
##################################
function restart_sshd() {
    service sshd restart
}

function main() {
    if [ $# -ne 1 ]; then
        usage && return 1
    fi
    local method=$1
    if [ "${method}" == "clear" ]; then
        backup
        clear_listenaddress
        restore
        restart_sshd
    elif [ "${method}" == "refresh" ]; then
        backup
        add_start_end
        clear_listenaddress
        add_listenaddress
        restore
        restart_sshd
    else
        usage && return 1
    fi
}

main ""$@""
exit $?
