#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
set +x

function gen_random_pwd() {
    while [ 1 ]; do
        # 从random获取随机数，并过滤掉etcd三方件不支持的特殊字符"$" "\" "'" '"'，以及expect会失败的以-开头
        random_pwd=$(cat /dev/random | tr -dc '[:lower:][:upper:][:digit:]!#%&()*+,-./:;<=>?@[]^`{_|}~' | head -c 16 | grep "[[:lower:]]" | grep "[[:upper:]]" | grep "[[:digit:]]" | grep "[[:punct:]]" | grep -v "^[[:punct:]]")
        if [ -n "${random_pwd}" ]; then
            echo ${random_pwd}
            break
        fi
    done
}

function check_havege_service() {
    status=$(systemctl is-active haveged)
    if [ "${status}" != "active" ]; then
        # 启动haveged服务，保证系统有足够的熵产生随机数
        systemctl enable haveged >/dev/null 2>&1
        systemctl start haveged >/dev/null 2>&1
    fi
}

check_havege_service
gen_random_pwd
exit 0
