#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
PYTHON_PATH=$1

function unzip_python() {
    [ -d "${PYTHON_PATH}/arbitration_python" ] && return 0

    mkdir -p ${PYTHON_PATH}
    unzip /opt/arbitration_file/EnvPython*.zip -d ${PYTHON_PATH} >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "get arbitration python failed"
        return 1
    fi
    local python_package=$(find "${PYTHON_PATH}" -name "python*.zip")
    [[ ! -e "${python_package}" ]] && return 1
    cd ${PYTHON_PATH}/
    [ -d arbitration_python ] && rm -rf arbitration_python
    mkdir -p arbitration_python
    unzip "${python_package}" -darbitration_python >/dev/null
    chmod -R 750 ${PYTHON_PATH}/arbitration_python/bin/python
}

unzip_python
exit $?
