#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
##################################################
#
# 清理ntp服务器配置信息
#
##################################################
function clear_server() {
    sed -i '/^server /d' /etc/ntp.conf
}

function _server_is_my_ip() {
    local ip=$1
    if [ "${ip}" == "" ]; then
        return 1
    fi

    . ./public.sh
    env_ips=$(get_current_ips)
    local real_ip=$(get_real_full_ip ${ip})
    if [[ $(echo "${env_ips}" | grep -iwF "${real_ip}") != "" ]]; then
        return 0
    else
        return 1
    fi
}

function _add_server_remote_prefer() {
    local ip=$1
    echo "server ${ip} burst iburst maxpoll 7 prefer true" >>/etc/ntp.conf
}

function _add_server_remote_not_prefer() {
    local ip=$1
    echo "server ${ip} burst iburst maxpoll 7" >>/etc/ntp.conf
}

##################################################
#
# 添加ntp服务器配置信息
#
##################################################
function add_server() {
    local activeIp=$1
    if [ "${activeIp}" == "" ]; then
        echo "no server added."
        return 1
    fi

    local standbyIp=$2
    local is_local_ntp_server="false"

    _server_is_my_ip ${activeIp}
    local active_is_local=$?
    _server_is_my_ip ${standbyIp}
    local standby_is_local=$?
    if [ ${active_is_local} -eq 0 -o ${standby_is_local} -eq 0 ]; then
        echo "NTP server cannot be server itself."
        return 1
    fi

    $(_add_server_remote_prefer ${activeIp})

    if [ "${activeIp}" == "${standbyIp}" ]; then
        echo "activeIP ${activeIp} and standbyIp ${standbyIp} are same, only add once."
        return 0
    fi
    $(_add_server_remote_not_prefer ${standbyIp})
}

function backup() {
    cp -p /etc/ntp.conf /etc/ntp.conf_for_arbitration
}

function main() {
    for i in {1..3}; do
        [[ ${1#-} == "cmd" ]] && {
            cmd=$2
            shift 2
        }
        [[ ${1#-} == "active" ]] && {
            active=$2
            shift 2
        }
        [[ ${1#-} == "standby" ]] && {
            standby=$2
            shift 2
        }
    done
    if [ "${cmd}" == "add_server" ]; then
        add_server ${active} ${standby}
        return $?
    elif [ "${cmd}" == "clear_server" ]; then
        clear_server
        return $?
    elif [ "${cmd}" == "backup" ]; then
        backup
        return $?
    fi
}

main $@
exit $?
