#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
function show_ntp_status() {
    systemctl status ntpd
}

########################################
#
# 查询当前NTP是否正常运行
#
########################################
function check_ntp_status() {
    systemctl status ntpd | grep "Active" | grep "running" &>/dev/null
    if [ $? -ne 0 ]; then
        echo "ntpd is not running."
        return 1
    fi
    echo "ntpd is running"
    return 0
}

########################################
#
# 查询NTP跟踪是否正常
#
########################################
function check_ntp_track() {
    ntpq -np | grep '^\*' &>/dev/null
    if [ $? -eq 0 ]; then
        echo "ntpd is tracking"
        return 0
    fi
    echo "ntpd is not tracking"
    return 1
}

########################################
#
# 查询NTP跟踪是否正常，返回结果为ns
#
########################################
function get_ntp_offset() {
    check_ntp_track || return 1
    local offset=$(ntpq -np | grep '^\*' | awk {'print $9'})
    offset=${offset#-}
    offset=$(echo "$offset * 1000000" | bc)
    offset=${offset%.*}
    echo ${offset}
}

function start_ntp() {
    systemctl start ntpd
    return $?
}

function stop_ntp() {
    systemctl stop ntpd
    return $?
}

function restart_ntp() {
    systemctl restart ntpd
    return $?
}

function enable_ntp() {
    systemctl disable chronyd
    systemctl enable ntpd
    return $?
}

function using_server() {
    check_ntp_track &>/dev/null || return 1
    local using_ip=$(ntpq -np | grep '^\*' | awk {'print $1'} | awk -F'*' {'print $2'})
    echo ${using_ip}
}

function check() {
    systemctl is-enabled ntpd | egrep "enabled|disabled" &>/dev/null
    if [ $? -ne 0 ]; then
        echo "ntpd not support"
        return 1
    fi
}

function main() {
    $(check) || return 0
    [[ ${1#-} == "cmd" ]] && {
        cmd=$2
        shift 2
    }
    if [ "${cmd}" == "show_ntp_status" ]; then
        show_ntp_status
        return $?
    elif [ "${cmd}" == "check_ntp_status" ]; then
        check_ntp_status
        return $?
    elif [ "${cmd}" == "check_ntp_track" ]; then
        check_ntp_track
        return $?
    elif [ "${cmd}" == "offset" ]; then
        get_ntp_offset
        return $?
    elif [ "${cmd}" == "start" ]; then
        start_ntp
        return $?
    elif [ "${cmd}" == "stop" ]; then
        stop_ntp
        return $?
    elif [ "${cmd}" == "restart" ]; then
        restart_ntp
        return $?
    elif [ "${cmd}" == "enable" ]; then
        enable_ntp
        return $?
    elif [ "${cmd}" == "using_server" ]; then
        using_server
        return $?
    fi
}

main $@
exit $?
